/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PatternPackageReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringReferenceUtils {
    @NotNull
    public static PsiReference[] getPsiPackagesReferences(@NotNull PsiElement element, @Nullable String text, int startInElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/SpringReferenceUtils", "getPsiPackagesReferences"));
        }
        PsiReference[] psiReferenceArray = SpringReferenceUtils.getPsiPackagesReferences(element, text, startInElement, ",; \n\t");
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringReferenceUtils", "getPsiPackagesReferences"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getPsiPackagesReferences(@NotNull PsiElement element, @Nullable String text, int startInElement, String delimiters) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/SpringReferenceUtils", "getPsiPackagesReferences"));
        }
        return SpringReferenceUtils.getPsiPackagesReferences(element, text, startInElement, delimiters, SpringReferenceUtils.getResolveScope(element));
    }

    public static PsiReference[] getPsiPackagesReferences(final @NotNull PsiElement element, final @Nullable String text, final int startInElement, String delimiters, final @NotNull GlobalSearchScope scope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/SpringReferenceUtils", "getPsiPackagesReferences"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/utils/SpringReferenceUtils", "getPsiPackagesReferences"));
        }
        if (text == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList list = new SmartList();
        new DelimitedListProcessor(delimiters, (List)list){
            final /* synthetic */ List val$list;
            {
                this.val$list = list;
                super(x0);
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                String packageName = text.substring(start, end);
                String trimmedPackageName = packageName.trim();
                int spacesNumber = packageName.indexOf(trimmedPackageName);
                PatternPackageReferenceSet referenceSet = new PatternPackageReferenceSet(trimmedPackageName, element, start + spacesNumber + startInElement, scope);
                this.val$list.addAll(referenceSet.getReferences());
            }
        }.processText(text);
        return list.isEmpty() ? PsiReference.EMPTY_ARRAY : list.toArray(new PsiReference[list.size()]);
    }

    private static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/SpringReferenceUtils", "getResolveScope"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return GlobalSearchScope.allScope((Project)element.getProject());
        }
        boolean inTestSource = ProjectRootsUtil.isInTestSource((PsiFile)element.getContainingFile());
        return module.getModuleRuntimeScope(inTestSource);
    }

    public static boolean processSeparatedString(String str, String delimiter, PairProcessor<String, Integer> processor) {
        String s;
        int index;
        if (str == null) {
            return true;
        }
        if (StringUtil.isEmptyOrSpaces((String)str)) {
            return processor.process((Object)str, (Object)0);
        }
        int pos = 0;
        while ((index = str.indexOf(delimiter, pos)) != -1) {
            int nextPos = index + delimiter.length();
            String token = str.substring(pos, index);
            if (token.length() != 0 && !processor.process((Object)token.trim(), (Object)(pos + token.indexOf(token.trim())))) {
                return false;
            }
            pos = nextPos;
        }
        return pos >= str.length() || processor.process((Object)(s = str.substring(pos, str.length())).trim(), (Object)(pos + s.indexOf(s.trim())));
    }
}

