/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.clientBundle.css.GwtCssDeclarationsManager;
import com.intellij.gwt.clientBundle.css.language.GwtCssLanguage;
import com.intellij.gwt.clientBundle.css.language.psi.GwtCssDef;
import com.intellij.gwt.clientBundle.jam.CssResourceClassJamElement;
import com.intellij.gwt.clientBundle.jam.CssResourceMethodJamElement;
import com.intellij.gwt.codeInsight.GwtMethodGenerationUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.inspections.CreateCssClassLocalQuickFix;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssResourceClassErrorsInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection", "checkClass"));
        }
        if (!CssResourceClassErrorsInspection.shouldCheck((PsiElement)aClass)) {
            return null;
        }
        CssResourceClassJamElement element = CssResourceClassJamElement.getJamElement(aClass);
        if (element == null) {
            return null;
        }
        Set<CssFile> cssFiles = element.findCssFiles(false, false);
        CssFile mainCssFile = (CssFile)ContainerUtil.getFirstItem(cssFiles, null);
        if (mainCssFile == null) {
            return null;
        }
        MultiMap unusedCssClasses = new MultiMap();
        for (CssFile cssFile : cssFiles) {
            GwtCssDeclarationsManager.collectDeclarations(cssFile, CssClass.class, unusedCssClasses);
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (CssResourceMethodJamElement methodElement : element.getCssMethods()) {
            ProblemHighlightType type;
            PsiLiteral place;
            String className = methodElement.getCssClassName();
            unusedCssClasses.remove((Object)className);
            if (!methodElement.findCssElements().isEmpty()) continue;
            PsiMethod method = methodElement.getPsiMethod();
            if (!aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)method.getContainingClass())) continue;
            CreateCssClassLocalQuickFix createClassFix = new CreateCssClassLocalQuickFix(mainCssFile, className);
            CreateCssDefLocalQuickFix createDefFix = new CreateCssDefLocalQuickFix(className, mainCssFile);
            String message = "'" + className + "' css class of '@def' element not found";
            PsiLiteral literal = methodElement.getClassNameAttributeElement().getPsiLiteral();
            if (literal != null) {
                place = literal;
                type = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            } else {
                place = CssResourceClassErrorsInspection.getElementToHighlight(method);
                type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            }
            result.add(manager.createProblemDescriptor((PsiElement)place, message, isOnTheFly, new LocalQuickFix[]{createClassFix, createDefFix}, type));
        }
        if (!unusedCssClasses.isEmpty()) {
            String quickFixName;
            String message;
            Set set = unusedCssClasses.keySet();
            if (set.size() == 1) {
                String className = (String)set.iterator().next();
                message = "Css class '" + className + "' does not have corresponding method";
                quickFixName = "Create method for '" + className + "'";
            } else {
                message = set.size() + " css classes do not have corresponding methods";
                quickFixName = "Create missing methods";
            }
            CreateMissingMethodsQuickFix fix = new CreateMissingMethodsQuickFix(aClass, set, quickFixName);
            result.add(manager.createProblemDescriptor(CssResourceClassErrorsInspection.getElementToHighlight(aClass), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return result.toArray(new ProblemDescriptor[result.size()]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("CssResource Errors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection", "getDisplayName"));
        }
        return "CssResource Errors";
    }

    @NotNull
    public String getShortName() {
        if ("GwtCssResourceErrors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection", "getShortName"));
        }
        return "GwtCssResourceErrors";
    }

    private static class CreateCssDefLocalQuickFix
    extends BaseGwtLocalQuickFix {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.clientBundle.CssResourceClassErrorsInspection.CreateCssDefLocalQuickFix");
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.def.declaration", new Object[0]);
        private final String myDefName;
        private final CssFile myCssFile;

        public CreateCssDefLocalQuickFix(String defName, CssFile cssFile) {
            super(GwtBundle.message("quickfix.name.create.def.declaration.for.0", defName));
            this.myDefName = defName;
            this.myCssFile = cssFile;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection$CreateCssDefLocalQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection$CreateCssDefLocalQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection$CreateCssDefLocalQuickFix", "applyFix"));
            }
            VirtualFile virtualFile = this.myCssFile.getOriginalFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles()) {
                return;
            }
            try {
                CssStylesheet stylesheet = this.myCssFile.getStylesheet();
                GwtCssDef cssDef = (GwtCssDef)stylesheet.getRulesetList().add((PsiElement)CreateCssDefLocalQuickFix.createCssDef(project, this.myDefName));
                GwtCssDef processed = (GwtCssDef)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)cssDef);
                OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, virtualFile, processed.getTextRange().getEndOffset() - 1);
                FileEditorManager.getInstance((Project)project).openEditor(fileDescriptor, true);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static GwtCssDef createCssDef(Project project, String defName) {
            PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy_.css", (Language)GwtCssLanguage.GWT_CSS_LANGUAGE, (CharSequence)("@def " + defName + ";"));
            CssRulesetList rulesetList = ((CssFile)file).getStylesheet().getRulesetList();
            return (GwtCssDef)PsiTreeUtil.findChildOfType((PsiElement)rulesetList, GwtCssDef.class);
        }
    }

    private static class CreateMissingMethodsQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.missing.methods", new Object[0]);
        private final PsiClass myClass;
        private final Set<String> myClassNames;

        public CreateMissingMethodsQuickFix(PsiClass aClass, Set<String> classNames, String name) {
            super(name);
            this.myClass = aClass;
            this.myClassNames = classNames;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection$CreateMissingMethodsQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection$CreateMissingMethodsQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection$CreateMissingMethodsQuickFix", "applyFix"));
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)this.myClass);
            for (String className : this.myClassNames) {
                String methodName = GwtMethodGenerationUtil.convertStringToMethodName(className, PsiNameHelper.getInstance((Project)project), languageLevel, "class");
                PsiMethod method = GwtMethodGenerationUtil.addStringMethod(this.myClass, methodName);
                if (!methodName.equals(className)) {
                    String annotationText = "@com.google.gwt.resources.client.CssResource.ClassName(\"" + className + "\")";
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    method.getModifierList().add((PsiElement)elementFactory.createAnnotationFromText(annotationText, (PsiElement)this.myClass));
                }
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
            }
        }
    }
}

