/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.rpc.GwtSerializableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtInconsistentSerializableClassInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtInconsistentSerializableClassInspection");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.incorrect.serializable.class", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentSerializableClassInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GwtInconsistentSerializableClass" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentSerializableClassInspection", "getShortName"));
        }
        return "GwtInconsistentSerializableClass";
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiField[] psiFields;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtInconsistentSerializableClassInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtInconsistentSerializableClassInspection", "checkClass"));
        }
        GwtFacet gwtFacet = GwtInconsistentSerializableClassInspection.getFacet((PsiElement)aClass);
        if (gwtFacet == null || aClass instanceof PsiTypeParameter) {
            return null;
        }
        PsiFile containingFile = aClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List<GwtModule> gwtModules = GwtModulesManager.getInstance(manager.getProject()).findGwtModulesByClientSourceFile(virtualFile);
        if (gwtModules.isEmpty()) {
            return null;
        }
        GwtSerializableUtil.SerializableChecker serializableChecker = GwtSerializableUtil.createSerializableChecker(gwtFacet, true);
        if (!serializableChecker.isMarkedSerializable(aClass)) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
        for (PsiField psiField : psiFields = aClass.getFields()) {
            PsiType type;
            if (psiField.hasModifierProperty("transient") || serializableChecker.isSerializable(type = psiField.getType())) continue;
            String description = GwtBundle.message("problem.description.field.0.is.not.serializable", type.getPresentableText());
            PsiTypeElement element = psiField.getTypeElement();
            if (element == null) {
                element = psiField;
            }
            descriptors.add(manager.createProblemDescriptor((PsiElement)element, description, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        if (!GwtSerializableUtil.hasPublicNoArgConstructor(aClass) && !aClass.isEnum()) {
            LOG.assertTrue(aClass.getName() != null, (Object)aClass);
            PsiMethod constructor = GwtSerializableUtil.findNoArgConstructor(aClass);
            String description = GwtBundle.message("problem.description.serializable.class.should.provide.public.no.args.constructor", new Object[0]);
            if (constructor == null) {
                LocalQuickFixAndIntentionActionOnPsiElement quickfix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass);
                descriptors.add(manager.createProblemDescriptor(GwtInconsistentSerializableClassInspection.getElementToHighlight(aClass), description, (LocalQuickFix)quickfix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            } else if (!gwtFacet.getSdkVersion().isPrivateNoArgConstructorInSerializableClassAllowed()) {
                LocalQuickFixAndIntentionActionOnPsiElement quickfix = QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)constructor, "public", true, true);
                descriptors.add(manager.createProblemDescriptor(GwtInconsistentSerializableClassInspection.getElementToHighlight(constructor), description, (LocalQuickFix)quickfix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            }
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }
}

