/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.facet.FacetManager;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.run.GwtCommandLineState;
import com.intellij.gwt.run.GwtCommandLineStateBase;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.gwt.run.GwtDevModeServerProvider;
import com.intellij.gwt.run.GwtRunConfigurationEditor;
import com.intellij.gwt.run.GwtRunConfigurationFactory;
import com.intellij.gwt.run.GwtSuperDevModeState;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtRunConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements CommonProgramRunConfigurationParameters {
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String PAGE = "page";
    private GwtRunConfigurationState myState = new GwtRunConfigurationState();

    public GwtRunConfiguration(String name, Project project, GwtRunConfigurationFactory configurationFactory) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, true), (ConfigurationFactory)configurationFactory);
    }

    public GwtRunConfiguration(Project project, GwtRunConfigurationFactory configurationFactory) {
        this(GwtBundle.message("default.gwt.run.configuration.name", new Object[0]), project, configurationFactory);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new GwtRunConfigurationEditor(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Collection<GwtModule> gwtModules;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/gwt/run/GwtRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/gwt/run/GwtRunConfiguration", "getState"));
        }
        Module module = this.getModule();
        if (module == null) {
            throw CantRunException.noModuleConfigured((String)((JavaRunConfigurationModule)this.getConfigurationModule()).getModuleName());
        }
        GwtFacet facet = (GwtFacet)FacetManager.getInstance((Module)module).getFacetByType(GwtFacetType.ID);
        if (facet == null) {
            throw new ExecutionException(GwtBundle.message("error.text.gwt.facet.not.configured.in.module.0", module.getName()));
        }
        Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (jdk == null) {
            throw CantRunException.noJdkForModule((Module)module);
        }
        if (facet.getSdkVersion().isModulesToLoadSpecifiedInDevMode() && (gwtModules = GwtModulesManager.getInstance(module.getProject()).getCompilableGwtModules(module, false)).isEmpty()) {
            throw new ExecutionException(GwtBundle.message("error.text.no.gwt.modules.in.module.0", module.getName()));
        }
        GwtSdk sdk = ((GwtFacetConfiguration)facet.getConfiguration()).getSdk();
        if (!sdk.isValid()) {
            throw new ExecutionException(GwtBundle.message("error.text.gwt.sdk.is.not.specified.correctly", module.getName()));
        }
        GwtDevModeServer selectedServer = null;
        block0: for (GwtDevModeServerProvider provider : (GwtDevModeServerProvider[])GwtDevModeServerProvider.EP_NAME.getExtensions()) {
            for (GwtDevModeServer gwtDevModeServer : provider.getServers()) {
                if (!gwtDevModeServer.getId().equals(this.myState.SERVER_ID)) continue;
                selectedServer = gwtDevModeServer;
                continue block0;
            }
        }
        if (selectedServer == null) {
            throw new ExecutionException("Unknown GWT Dev Mode server: " + this.myState.SERVER_ID);
        }
        GwtCommandLineStateBase state = this.myState.USE_SUPER_DEV_MODE && !GwtRunConfiguration.useNewSuperDevModeLauncher() ? new GwtSuperDevModeState(facet, env, this.myState, executor) : new GwtCommandLineState(facet, env, this, selectedServer, executor);
        return state;
    }

    public static boolean useNewSuperDevModeLauncher() {
        return Boolean.parseBoolean(System.getProperty("idea.gwt.use.new.sdm.launcher", "true"));
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        ((JavaRunConfigurationModule)this.getConfigurationModule()).checkForWarning();
    }

    public GwtRunConfigurationState getState() {
        return this.myState;
    }

    public Collection<Module> getValidModules() {
        return this.getAllModules();
    }

    @Nullable
    public Module getModule() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
    }

    public void readExternal(Element element) throws InvalidDataException {
        String page;
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        this.myState = new GwtRunConfigurationState();
        XmlSerializer.deserializeInto((Object)this.myState, (Element)element);
        this.readModule(element);
        Element module = element.getChild(MODULE);
        if (module != null && !StringUtil.isEmpty((String)(page = module.getAttributeValue(PAGE)))) {
            this.myState.RUN_PAGE = page;
        }
        super.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.writeModule(element);
        XmlSerializer.serializeInto((Object)this.myState, (Element)element, (SerializationFilter)SERIALIZATION_FILTERS);
        super.writeExternal(element);
    }

    public void setPage(String runPage) {
        if (runPage == null) {
            runPage = "";
        }
        this.myState.RUN_PAGE = runPage;
    }

    public String getPage() {
        return this.myState.RUN_PAGE;
    }

    public void setProgramParameters(@Nullable String value) {
        this.myState.SHELL_PARAMETERS = value;
    }

    @Nullable
    public String getProgramParameters() {
        return this.myState.SHELL_PARAMETERS;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.myState.WORKING_DIRECTORY = value;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.myState.WORKING_DIRECTORY;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/gwt/run/GwtRunConfiguration", "setEnvs"));
        }
        this.myState.ENVIRONMENT_VARIABLES = envs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myState.ENVIRONMENT_VARIABLES;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtRunConfiguration", "getEnvs"));
        }
        return map;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myState.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.myState.PASS_PARENT_ENVS;
    }

    public static class GwtRunConfigurationState {
        @NonNls
        public String VM_PARAMETERS = "-Xmx512m";
        public String SHELL_PARAMETERS = "";
        public String RUN_PAGE = "";
        public String CUSTOM_WEB_XML;
        public String GWT_MODULE;
        public String SERVER_ID = "default";
        public boolean OPEN_IN_BROWSER = true;
        public boolean START_JAVASCRIPT_DEBUGGER = false;
        public String BROWSER;
        public boolean UPDATE_RESOURCES_ON_FRAME_DEACTIVATION;
        public boolean USE_SUPER_DEV_MODE = false;
        public boolean PASS_PARENT_ENVS = true;
        public String ALTERNATIVE_JRE_PATH;
        public String WORKING_DIRECTORY;
        @Tag(value="envs")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="env", keyAttributeName="name")
        public Map<String, String> ENVIRONMENT_VARIABLES = new HashMap<String, String>();
        @Tag(value="gwt-modules")
        @AbstractCollection(surroundWithTag=false, elementTag="gwt-module", elementValueAttribute="name")
        public List<String> GWT_MODULES = new ArrayList<String>();

        @Transient
        @Nullable
        public List<String> getGwtModules() {
            if (!this.GWT_MODULES.isEmpty()) {
                return this.GWT_MODULES;
            }
            if (this.GWT_MODULE != null) {
                return Collections.singletonList(this.GWT_MODULE);
            }
            return null;
        }

        @Transient
        public void setGwtModules(@Nullable List<String> gwtModules) {
            this.GWT_MODULES = Collections.emptyList();
            this.GWT_MODULE = null;
            if (gwtModules != null) {
                if (gwtModules.size() == 1) {
                    this.GWT_MODULE = gwtModules.get(0);
                } else {
                    this.GWT_MODULES = Collections.unmodifiableList(new ArrayList<String>(gwtModules));
                }
            }
        }
    }
}

