/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.dsm.DsmBundle;
import com.intellij.dsm.ui.DsmLegend;
import com.intellij.dsm.ui.DsmView;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DsmUIUtil {
    static final String TOOLWINDOW_ID = DsmBundle.message("dsm", new Object[0]);
    private static final Icon LEGEND = IconLoader.getIcon((String)"/icons/legend.png");

    private DsmUIUtil() {
    }

    static void showView(Project project, DsmView view, String name) {
        for (JComponent component : UIUtil.uiTraverser((Component)view).traverse().filter(JComponent.class)) {
            PopupHandler.installPopupHandler((JComponent)component, (String)"DSM.Popup", (String)"DSM.View");
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            toolWindow = toolWindowManager.registerToolWindow(TOOLWINDOW_ID, true, ToolWindowAnchor.RIGHT, (Disposable)project, true);
            new ContentManagerWatcher(toolWindow, toolWindow.getContentManager());
        }
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        Rectangle bounds = WindowManager.getInstance().getIdeFrame(project).suggestChildFrameBounds();
        toolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.FLOATING, bounds);
        JPanel p = new JPanel(new BorderLayout());
        p.putClientProperty("DSM", "OUTER_WITH_TOOLWINDOW");
        p.add((Component)view, "Center");
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)p, name, false);
        JComponent tableComponent = view.getTable().getComponent();
        content.setPreferredFocusableComponent(tableComponent);
        contentManager.addContent(content);
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction("DSM.Toolbar");
        ActionToolbar toolbar = actionManager.createActionToolbar("ToolWindow", group, true);
        toolbar.setTargetComponent(tableComponent);
        JPanel topComponent = new JPanel(new BorderLayout());
        topComponent.add((Component)toolbar.getComponent(), "West");
        if (Registry.is((String)"dsm.retina.darcula.legend")) {
            topComponent.add((Component)new DsmLegend(tableComponent), "East");
        } else {
            topComponent.add((Component)new JLabel(LEGEND), "East");
        }
        p.add((Component)topComponent, "North");
        toolWindow.activate(() -> contentManager.setSelectedContent(content, true));
    }
}

