/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.NodeVisitor;
import java.awt.Graphics2D;
import java.awt.Rectangle;

class BandPainter<N>
implements NodeVisitor<N> {
    private final Graphics2D g;
    private final DsmTableImpl<N> myDsmTable;

    public BandPainter(DsmTableImpl<N> dsmTable, Graphics2D g) {
        this.myDsmTable = dsmTable;
        this.g = g;
    }

    @Override
    public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
    }

    @Override
    public void visitAfterExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isLast) {
    }

    @Override
    public void visitBeforeExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isLast) {
        Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(node);
        if (r.y == 0) {
            return;
        }
        this.g.setPaint(DsmTableConstants.COLOR_GRID_COLOR.darker());
        this.g.drawLine(0, r.y + 1, r.y + r.height + 1, r.y + 1);
        this.g.drawLine(0, r.y + r.height + 1, r.y + r.height + 1, r.y + r.height + 1);
        this.g.drawLine(r.y + 1, 0, r.y + 1, r.y + r.height);
        this.g.drawLine(r.y + r.height + 1, 0, r.y + r.height + 1, r.y + r.height);
    }

    @Override
    public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean last) {
    }
}

