/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux;

import java.io.IOException;
import java.io.OutputStream;
import org.w3c.www.mux.MuxSession;
import org.w3c.www.mux.MuxWriter;

public class MuxOutputStream
extends OutputStream {
    protected static final boolean debug = false;
    protected MuxSession session = null;
    protected int sessid = -1;
    protected MuxWriter writer = null;
    protected int fragsz = 512;
    protected int avail_credit = 4096;
    protected boolean closed = false;

    protected synchronized void notifyCredit(int n) {
        this.avail_credit += n;
        this.notifyAll();
    }

    protected synchronized void notifyControl(int n) {
        this.fragsz = n;
    }

    private synchronized void send(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            while (this.avail_credit <= 0) {
                if (this.closed) {
                    throw new IOException("Broken pipe");
                }
                this.writer.flush();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Interrupted IO !");
                }
            }
            while (this.avail_credit > 0) {
                if (this.fragsz <= 0) {
                    int n3 = Math.min(this.avail_credit, n2);
                    this.writer.writeData(this.sessid, byArray, n, n3);
                    n2 -= n3;
                    n += n3;
                    this.avail_credit -= n3;
                    continue;
                }
                if (n2 < this.fragsz) {
                    this.writer.writeData(this.sessid, byArray, n, n2);
                    this.avail_credit -= n2;
                    return;
                }
                this.writer.writeData(this.sessid, byArray, n, this.fragsz);
                n2 -= this.fragsz;
                n += this.fragsz;
                this.avail_credit -= this.fragsz;
            }
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.send(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.session.sendFIN();
        this.notifyAll();
    }

    protected MuxOutputStream(MuxSession muxSession) {
        this.session = muxSession;
        this.sessid = muxSession.getIdentifier();
        this.writer = muxSession.getMuxStream().getMuxWriter();
    }
}

