/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.build;

import com.intellij.execution.ExecutionException;
import com.intellij.javaee.appServerIntegrations.AppServerSpecificValidator;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.ejbc.AppcRunner;
import com.intellij.javaee.weblogic.ejbc.EjbcRunner;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class WebLogicServerValidator
extends AppServerSpecificValidator {
    private final Project myProject;
    private final ApplicationServer myServer;
    private final Version myVersion;
    private final boolean myUseAppc;
    private final String myDisplayName;

    public WebLogicServerValidator(@NotNull Project project, ApplicationServer server, Version version, boolean useAppc) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/weblogic/build/WebLogicServerValidator", "<init>"));
        }
        this.myProject = project;
        this.myServer = server;
        this.myVersion = version;
        this.myUseAppc = useAppc;
        this.myDisplayName = useAppc ? WeblogicBundle.message("weblogic.appc.name", new Object[0]) : WeblogicBundle.message("weblogic.ejbc.name", new Object[0]);
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public void validate(JavaeeFacet facet, File output, CompileContext context) throws ExecutionException {
        EjbcRunner runner = this.myUseAppc ? new AppcRunner(facet, this.myVersion) : new EjbcRunner(facet, this.myVersion);
        runner.run(output, context, this.myServer);
    }

    public void validate(Artifact artifact, File output, CompileContext context) throws ExecutionException {
        EjbcRunner runner = this.myUseAppc ? new AppcRunner(artifact, this.myProject, this.myVersion) : new EjbcRunner(artifact, this.myProject, this.myVersion);
        runner.run(output, context, this.myServer);
    }
}

