/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanImportResourceConverter
extends Converter<PsiFileSystemItem>
implements CustomReferenceConverter<PsiFileSystemItem> {
    public static final Condition<PsiFileSystemItem> SPRING_XML_CONDITION = item -> {
        if (item.isDirectory()) {
            return false;
        }
        VirtualFile virtualFile = item.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        PsiFile psiFile = item.getManager().findFile(virtualFile);
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        return SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile));
    };

    public PsiFileSystemItem fromString(@Nullable @NonNls String s, ConvertContext context) {
        return BeanImportResourceConverter.createFileReferenceSet((PsiElement)context.getXmlElement()).resolve();
    }

    public String toString(@Nullable PsiFileSystemItem item, ConvertContext context) {
        return null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiFileSystemItem> genericDomValue, PsiElement element, ConvertContext context) {
        FileReferenceSet set = BeanImportResourceConverter.createFileReferenceSet(element);
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/BeanImportResourceConverter", "createReferences"));
        }
        return fileReferenceArray;
    }

    private static FileReferenceSet createFileReferenceSet(PsiElement element) {
        return new FileReferenceSet(element){

            public boolean isAbsolutePathReference() {
                return false;
            }

            protected boolean isSoft() {
                return true;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return SPRING_XML_CONDITION;
            }
        };
    }
}

