/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.Annotations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import net.sourceforge.transparent.Annotations.AnnotationLineParser;
import net.sourceforge.transparent.Annotations.CCaseFileAnnotation;
import net.sourceforge.transparent.History.CCaseFileRevision;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;

public class CCaseAnnotationProvider
implements AnnotationProvider {
    @NonNls
    private static final String BRANCH_SIG = "branch";
    @NonNls
    private static final String ERROR_SIG = "Invalid manager operation";
    @NonNls
    private static final String ERROR_TEXT = "Probably type manager does not contain Annotate method for this file type";
    Project project;
    TransparentVcs host;

    public CCaseAnnotationProvider(Project project, TransparentVcs host) {
        this.project = project;
        this.host = host;
    }

    public FileAnnotation annotate(VirtualFile file) throws VcsException {
        String canonicalName = VcsUtil.getCanonicalPath((String)file.getPath());
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(file);
        if (status == FileStatus.HIJACKED) {
            canonicalName = canonicalName + "@@";
        }
        return this.runAnnotation(file, canonicalName);
    }

    public FileAnnotation annotate(VirtualFile file, VcsFileRevision vcsRev) throws VcsException {
        String canonicalName = VcsUtil.getCanonicalPath((String)file.getPath());
        canonicalName = canonicalName + vcsRev.getRevisionNumber().asString();
        return this.runAnnotation(file, canonicalName);
    }

    private FileAnnotation runAnnotation(VirtualFile file, String path) throws VcsException {
        String[] lines;
        String format = "\"%Sd #|# %-16.16u #|# %-40.40Vn #|# \"";
        String output = TransparentVcs.cleartoolWithOutput("annotate", "-out", "-", "-nco", "-nhe", "-fmt", format, path);
        if (output.contains(ERROR_SIG)) {
            throw new VcsException(ERROR_TEXT);
        }
        CCaseFileAnnotation annotation = new CCaseFileAnnotation(this.project, file);
        for (String line : lines = LineTokenizer.tokenize((CharSequence)output, (boolean)false)) {
            AnnotationLineParser.AnnotationLineInfo info = AnnotationLineParser.parse(line);
            annotation.addLineInfo(info.date, info.revision, info.committer, info.source);
        }
        return annotation;
    }

    public boolean isAnnotationValid(VcsFileRevision rev) {
        CCaseFileRevision ccRev = (CCaseFileRevision)rev;
        String action = ccRev.getAction();
        return action != null && action.indexOf(BRANCH_SIG) == -1;
    }
}

