/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicFieldBasedOptionDescription;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.transparent.CCaseConfig;
import net.sourceforge.transparent.CCaseSharedConfig;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClearCaseOptionsTopHitProvider
extends OptionsTopHitProvider {
    private static final String ID = "vcs.ClearCase";

    public String getId() {
        return "vcs";
    }

    @NotNull
    public Collection<BooleanOptionDescription> getOptions(final @Nullable Project project) {
        if (project != null) {
            for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)project).getAllVcss()) {
                if (!"ClearCase".equals(descriptor.getDisplayName())) continue;
                ArrayList<Object> options = new ArrayList<Object>();
                CCaseViewsManager manager = CCaseViewsManager.getInstance(project);
                final CCaseConfig config = CCaseConfig.getInstance(project);
                if (manager.isAnySnapshotView()) {
                    options.add(new PublicMethodBasedOptionDescription("ClearCase: Work Offline (on edit: hijack instead of checkout)", ID, "isOffline", "setOfflineMode"){

                        public Object getInstance() {
                            return config;
                        }
                    });
                }
                options.add(ClearCaseOptionsTopHitProvider.option(config, "ClearCase: Reserved Checkouts", "checkoutReserved"));
                options.add(ClearCaseOptionsTopHitProvider.option(config, "ClearCase: Check out automatically hijacked file on check in", "checkInUseHijack"));
                options.add(new PublicMethodBasedOptionDescription("ClearCase: Use UCM model", ID, "isUseUcmModel", "setUcmMode"){

                    public Object getInstance() {
                        return CCaseSharedConfig.getInstance(project);
                    }

                    public void setOptionState(boolean enabled) {
                        super.setOptionState(enabled);
                        if (enabled) {
                            CCaseViewsManager.getInstance(project).extractViewActivities();
                        }
                    }

                    protected void fireUpdated() {
                        TransparentVcs.getInstance(project).checkRootsForUCMMismatch();
                    }
                });
                options.add(ClearCaseOptionsTopHitProvider.option(config, "ClearCase: Synchronize activities on refresh", "synchActivitiesOnRefresh"));
                options.add(ClearCaseOptionsTopHitProvider.option(config, "ClearCase: Use \"-identical\" switch during check in", "useIdenticalSwitch"));
                options.add(ClearCaseOptionsTopHitProvider.option(config, "ClearCase: Restrict history records by " + config.getHistoryRevisionsMargin(), "isHistoryResticted"));
                Collection<BooleanOptionDescription> collection = Collections.unmodifiableCollection(options);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/ClearCaseOptionsTopHitProvider", "getOptions"));
                }
                return collection;
            }
        }
        List<BooleanOptionDescription> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/ClearCaseOptionsTopHitProvider", "getOptions"));
        }
        return list;
    }

    private static BooleanOptionDescription option(final Object instance, String option, String field) {
        return new PublicFieldBasedOptionDescription(option, ID, field){

            public Object getInstance() {
                return instance;
            }
        };
    }
}

