/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.History;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.sourceforge.transparent.History.CCaseHistoryParser;
import net.sourceforge.transparent.History.CCaseRevisionNumber;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.Nullable;

public class CCaseFileRevision
implements VcsFileRevision {
    private final String version;
    private final String submitter;
    private final String changeCcaseDate;
    private final String comment;
    private final String action;
    private final String labels;
    private final int order;
    private final String path;
    private byte[] content;
    private final Project myProject;

    public CCaseFileRevision(CCaseHistoryParser.SubmissionData data, String path, Project project) {
        this.myProject = project;
        this.version = data.version;
        this.submitter = data.submitter;
        this.comment = data.comment;
        this.action = data.action;
        this.labels = data.labels;
        this.order = data.order;
        this.changeCcaseDate = data.changeDate;
        this.path = path;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public byte[] getContent() throws IOException, VcsException {
        return this.content;
    }

    public String getBranchName() {
        return null;
    }

    public Date getRevisionDate() {
        return null;
    }

    public String getChangeCcaseDate() {
        return this.changeCcaseDate;
    }

    public String getAuthor() {
        return this.submitter;
    }

    public String getCommitMessage() {
        return this.comment;
    }

    public int getOrder() {
        return this.order;
    }

    public String getAction() {
        return this.action;
    }

    public String getLabels() {
        return this.labels;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return new CCaseRevisionNumber(this.version, this.order);
    }

    public byte[] loadContent() throws IOException, VcsException {
        String TMP_FILE_NAME = "idea_ccase";
        String EXT = ".tmp";
        String TITLE = "Can not issue Get command";
        try {
            File tmpFile = FileUtil.createTempFile((String)"idea_ccase", (String)".tmp");
            tmpFile.deleteOnExit();
            File tmpDir = tmpFile.getParentFile();
            File myTmpFile = new File(tmpDir, Long.toString(new Date().getTime()));
            myTmpFile.deleteOnExit();
            String out = TransparentVcs.cleartoolWithOutput("get", "-to", myTmpFile.getPath(), this.path + this.version);
            if (out.length() > 0) {
                VcsImplUtil.showErrorMessage((Project)this.myProject, (String)out, (String)"Can not issue Get command");
            } else {
                this.content = VcsUtil.getFileByteContent((File)myTmpFile);
            }
        }
        catch (IOException e) {
            this.content = null;
        }
        return this.content;
    }

    public int compareTo(Object revision) {
        return this.getRevisionNumber().compareTo((Object)((CCaseFileRevision)revision).getRevisionNumber());
    }
}

