/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.contexts.model.BeanClassSearchInheritorsCache;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.utils.search.executors.AbstractSpringBeanQueryExecutor;
import com.intellij.spring.model.utils.search.executors.CustomBeanWrappersQueryExecutor;
import com.intellij.spring.model.utils.search.executors.SpringAbstractBeanQueryExecutor;
import com.intellij.spring.model.utils.search.executors.SpringBeanFactoriesQueryExecutor;
import com.intellij.spring.model.utils.search.executors.SpringBeanFactoryClassesQueryExecutor;
import com.intellij.spring.model.utils.search.executors.XmlBeanClassQueryExecutor;
import com.intellij.spring.model.utils.search.executors.XmlBeanNameQueryExecutor;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocalXmlModelIndexProcessor {
    private final XmlFile myConfigFile;
    private final Module myModule;
    private final Project myProject;
    private final GlobalSearchScope myLocalFileSearchScope;
    private final boolean myIsInTestSource;
    private static final List<QueryExecutor<SpringBeanPointer, SpringBeanSearchParameters.BeanName>> ourByNameExecutors = ContainerUtil.immutableList((Object[])new QueryExecutor[]{XmlBeanNameQueryExecutor.INSTANCE, CustomBeanWrappersQueryExecutor.BeanName.INSTANCE});
    private final CachingProcessor<SpringModelSearchParameters.BeanName, SpringBeanSearchParameters.BeanName> myBeanNameProcessor = new CachingProcessor<SpringModelSearchParameters.BeanName, SpringBeanSearchParameters.BeanName>(){

        @Override
        protected ExecutorsQuery<SpringBeanPointer, SpringBeanSearchParameters.BeanName> createQuery(SpringModelSearchParameters.BeanName params) {
            return new ExecutorsQuery((Object)LocalXmlModelIndexProcessor.this.getByNameSearchParameters(params), ourByNameExecutors);
        }
    };
    private final ByClassCachingProcessor myBeansProcessor = new ByClassCachingProcessor((QueryExecutor)XmlBeanClassQueryExecutor.INSTANCE);
    private final ByClassCachingProcessor myFactoryBeansProcessor = new ByClassCachingProcessor((QueryExecutor)SpringBeanFactoriesQueryExecutor.INSTANCE);
    private final ByClassCachingProcessor myFactoryBeanClassesProcessor = new ByClassCachingProcessor((QueryExecutor)SpringBeanFactoryClassesQueryExecutor.INSTANCE);
    private final ByClassCachingProcessor myAbstractBeansProcessor = new ByClassCachingProcessor((QueryExecutor)SpringAbstractBeanQueryExecutor.INSTANCE);
    private final ByClassCachingProcessor myCustomBeanWrapperProcessor = new ByClassCachingProcessor((QueryExecutor)CustomBeanWrappersQueryExecutor.BeanClass.INSTANCE);

    LocalXmlModelIndexProcessor(XmlFile file, Module module) {
        this.myConfigFile = file;
        this.myModule = module;
        this.myProject = file.getProject();
        this.myLocalFileSearchScope = GlobalSearchScope.fileScope((PsiFile)this.myConfigFile);
        this.myIsInTestSource = ProjectRootsUtil.isInTestSource((PsiFile)this.myConfigFile);
    }

    Collection<XmlTag> getCustomBeanCandidates(String key) {
        SpringBeanSearchParameters.BeanName params = this.getByNameSearchParameters(SpringModelSearchParameters.byName((String)key));
        SmartList result = new SmartList();
        Processor processor = arg_0 -> LocalXmlModelIndexProcessor.lambda$getCustomBeanCandidates$0(key, (List)result, arg_0);
        CustomBeanWrappersQueryExecutor.AllWrappers.INSTANCE.execute(params, processor);
        return result;
    }

    List<SpringBeansPackagesScan> getComponentScans() {
        SmartList scans = new SmartList();
        Processor collectProcessor = arg_0 -> LocalXmlModelIndexProcessor.lambda$getComponentScans$1((List)scans, arg_0);
        SpringXmlBeansIndex.processComponentScans(this.getByNameSearchParameters(SpringModelSearchParameters.byName((String)"")), (Processor<SpringBeanPointer>)collectProcessor);
        return scans;
    }

    List<SpringBeanPointer> getAnnotationConfigs(Set<String> activeProfiles) {
        PsiClass annotationConfigAppContext = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)"org.springframework.context.annotation.AnnotationConfigApplicationContext");
        if (annotationConfigAppContext == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        CommonProcessors.CollectProcessor<SpringBeanPointer> processor = new CommonProcessors.CollectProcessor<SpringBeanPointer>((Collection)result){

            public boolean process(SpringBeanPointer pointer) {
                ProgressManager.checkCanceled();
                return super.process((Object)pointer);
            }

            protected boolean accept(SpringBeanPointer pointer) {
                return pointer.getSpringBean() instanceof SpringBean;
            }
        };
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)annotationConfigAppContext).withInheritors();
        this.myBeansProcessor.process(searchParameters, (Processor<SpringBeanPointer>)processor, activeProfiles);
        return result;
    }

    private SpringBeanSearchParameters.BeanName getByNameSearchParameters(@NotNull SpringModelSearchParameters.BeanName parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getByNameSearchParameters"));
        }
        SpringBeanSearchParameters.BeanName searchParameters = SpringBeanSearchParameters.byName(this.myProject, parameters);
        this.applyLocalSearchScope(searchParameters);
        return searchParameters;
    }

    @NotNull
    private SpringBeanSearchParameters.BeanClass getByClassSearchParameters(@NotNull SpringModelSearchParameters.BeanClass params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getByClassSearchParameters"));
        }
        SpringBeanSearchParameters.BeanClass searchParameters = SpringBeanSearchParameters.byClass(this.myProject, params);
        this.applyLocalSearchScope(searchParameters);
        SpringBeanSearchParameters.BeanClass beanClass = searchParameters;
        if (beanClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getByClassSearchParameters"));
        }
        return beanClass;
    }

    boolean processByName(SpringModelSearchParameters.BeanName params, Processor<SpringBeanPointer> processor, Set<String> activeProfiles) {
        return this.myBeanNameProcessor.process(params, processor, activeProfiles);
    }

    boolean processByClass(SpringModelSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor, Set<String> activeProfiles, boolean onlyPlainBeans) {
        if (!this.myBeansProcessor.process(params, processor, activeProfiles)) {
            return false;
        }
        if (params.isWithInheritors() && !this.processInheritors(params, processor, activeProfiles)) {
            return false;
        }
        if (onlyPlainBeans) {
            return true;
        }
        if (!this.myFactoryBeansProcessor.process(params, processor, activeProfiles)) {
            return false;
        }
        if (params.isEffectiveBeanTypes()) {
            if (!this.myFactoryBeanClassesProcessor.process(params, processor, activeProfiles)) {
                return false;
            }
            if (!this.processNonIndexedFactoryBeans(params, processor, activeProfiles)) {
                return false;
            }
        }
        if (!this.processAbstractBeans(params, processor, activeProfiles)) {
            return false;
        }
        return this.myCustomBeanWrapperProcessor.process(params, processor, activeProfiles);
    }

    private void applyLocalSearchScope(SpringBeanSearchParameters parameters) {
        parameters.setSearchScope(this.myLocalFileSearchScope);
        parameters.setVirtualFile(this.myConfigFile.getVirtualFile());
    }

    private boolean processInheritors(SpringModelSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor, Set<String> activeProfiles) {
        Collection<SpringModelSearchParameters.BeanClass> inheritorSearchParameters = BeanClassSearchInheritorsCache.getInheritorSearchParameters(this.myModule, this.myIsInTestSource, params);
        for (SpringModelSearchParameters.BeanClass inheritor : inheritorSearchParameters) {
            if (this.processByClass(inheritor, processor, activeProfiles, true)) continue;
            return false;
        }
        return true;
    }

    private boolean processNonIndexedFactoryBeans(SpringModelSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor, Set<String> activeProfiles) {
        SpringBeanSearchParameters.BeanClass searchParameters = this.getByClassSearchParameters(params);
        return AbstractSpringBeanQueryExecutor.processEffectiveBeanTypes(this.getNonIndexedFactoryBeans(this.myProject, activeProfiles), searchParameters, processor);
    }

    private boolean processAbstractBeans(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor, @NotNull Set<String> activeProfiles) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBeans"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBeans"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBeans"));
        }
        Collection<SpringBeanPointer> pointers = this.getAbstractBeanPointers(params, activeProfiles);
        if (!pointers.isEmpty()) {
            HashMap processedBeans = ContainerUtil.newHashMap();
            SpringBeanSearchParameters.BeanClass searchParameters = this.getByClassSearchParameters(params);
            for (SpringBeanPointer pointer : pointers) {
                if (this.processAbstractBean(pointer, searchParameters, processor, (Set<String>)new com.intellij.util.containers.hash.HashSet(), processedBeans, activeProfiles)) continue;
                return false;
            }
        }
        return true;
    }

    private Collection<SpringBeanPointer> getNonIndexedFactoryBeans(@NotNull Project project, Set<String> activeProfiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getNonIndexedFactoryBeans"));
        }
        SmartList nonIndexedBeans = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)nonIndexedBeans);
        for (SpringModelSearchParameters.BeanClass factoryBeanClass : LocalXmlModelIndexProcessor.getNonIndexedFactoryBeanClasses(project)) {
            this.processByClass(factoryBeanClass, (Processor<SpringBeanPointer>)processor, activeProfiles, true);
        }
        return nonIndexedBeans;
    }

    private static List<SpringModelSearchParameters.BeanClass> getNonIndexedFactoryBeanClasses(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getNonIndexedFactoryBeanClasses"));
        }
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "lambda$getNonIndexedFactoryBeanClasses$2"));
            }
            SmartList nonIndexedSearchParameters = new SmartList();
            for (PsiClass factoryBeanClass : SpringFactoryBeansManager.getInstance().getKnownBeanFactories(project)) {
                SpringModelSearchParameters.BeanClass searchParameters;
                if (factoryBeanClass.isInterface() || factoryBeanClass.hasModifierProperty("abstract") || LocalXmlModelIndexProcessor.isFactoryBeanClassInIndex(factoryBeanClass) || !(searchParameters = SpringModelSearchParameters.byClass((PsiClass)factoryBeanClass)).canSearch()) continue;
                nonIndexedSearchParameters.add(searchParameters);
            }
            return CachedValueProvider.Result.createSingleDependency((Object)nonIndexedSearchParameters, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    private static boolean isFactoryBeanClassInIndex(PsiClass factoryBeanClass) {
        String qualifiedName = factoryBeanClass.getQualifiedName();
        return qualifiedName == null || StringUtil.endsWith((CharSequence)qualifiedName, (CharSequence)"FactoryBean");
    }

    @NotNull
    private Collection<SpringBeanPointer> getAbstractBeanPointers(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Set<String> activeProfiles) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getAbstractBeanPointers"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getAbstractBeanPointers"));
        }
        SmartList abstractBeans = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)abstractBeans);
        this.myAbstractBeansProcessor.process(params, (Processor<SpringBeanPointer>)processor, activeProfiles);
        SmartList smartList = abstractBeans;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getAbstractBeanPointers"));
        }
        return smartList;
    }

    private boolean processAbstractBean(@NotNull SpringBeanPointer currentParent, @NotNull SpringBeanSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> consumer, @NotNull Set<String> noSOE, @NotNull Map<SpringBeanPointer, Set<PsiType>> map, @NotNull Set<String> activeProfiles) {
        if (currentParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentParent", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBean"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBean"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBean"));
        }
        if (noSOE == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noSOE", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBean"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBean"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "processAbstractBean"));
        }
        for (PsiType type : this.getSimpleBeanTypes(currentParent, noSOE, map, activeProfiles)) {
            PsiClass psiClass;
            if (params.matchesClass(type) && !consumer.process((Object)currentParent)) {
                return false;
            }
            if (!params.isEffectiveBeanTypes() || !(type instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null || !SpringFactoryBeansManager.getInstance().isFactoryBeanClass(psiClass)) continue;
            for (PsiType psiType : SpringFactoryBeansManager.getInstance().getObjectTypes(psiClass, currentParent.getSpringBean())) {
                if (!params.matchesClass(psiType) || consumer.process((Object)currentParent)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<PsiType> getSimpleBeanTypes(@NotNull SpringBeanPointer currentParent, @NotNull Set<String> noSOE, @NotNull Map<SpringBeanPointer, Set<PsiType>> map, @NotNull Set<String> activeProfiles) {
        if (currentParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentParent", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getSimpleBeanTypes"));
        }
        if (noSOE == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noSOE", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getSimpleBeanTypes"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getSimpleBeanTypes"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getSimpleBeanTypes"));
        }
        Set<PsiType> psiTypes = map.get(currentParent);
        if (psiTypes != null) {
            Set<PsiType> set = psiTypes;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getSimpleBeanTypes"));
            }
            return set;
        }
        SmartHashSet beanTypes = new SmartHashSet(1);
        CommonSpringBean springBean = currentParent.getSpringBean();
        if (springBean instanceof SpringBean) {
            SpringBean bean = (SpringBean)springBean;
            if (LocalXmlModelIndexProcessor.hasClassAttribute(bean)) {
                beanTypes.addAll(LocalXmlModelIndexProcessor.getSimpleBeanTypes(bean));
            } else {
                String parent;
                GenericAttributeValue parentBean = bean.getParentBean();
                if (DomUtil.hasXml((DomElement)parentBean) && StringUtil.isNotEmpty((String)(parent = parentBean.getRawText())) && !noSOE.contains(parent)) {
                    noSOE.add(parent);
                    for (SpringBeanPointer parentPointer : this.findParentsByName(parent, activeProfiles)) {
                        CommonSpringBean parentPointerSpringBean = parentPointer.getSpringBean();
                        if (!(parentPointerSpringBean instanceof SpringBean)) continue;
                        beanTypes.addAll(this.getSimpleBeanTypes(parentPointer, noSOE, map, activeProfiles));
                    }
                }
            }
        }
        map.put(currentParent, (Set<PsiType>)beanTypes);
        SmartHashSet smartHashSet = beanTypes;
        if (smartHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getSimpleBeanTypes"));
        }
        return smartHashSet;
    }

    private Collection<SpringBeanPointer> findParentsByName(@NotNull String parent, @NotNull Set<String> activeProfiles) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "findParentsByName"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "findParentsByName"));
        }
        SpringModelSearchParameters.BeanName parentBeanName = SpringModelSearchParameters.byName((String)parent);
        SmartList beans = new SmartList();
        Processor collectBeans = Processors.cancelableCollectProcessor((Collection)beans);
        this.processByName(parentBeanName, (Processor<SpringBeanPointer>)collectBeans, activeProfiles);
        return beans;
    }

    @NotNull
    private static Set<PsiType> getSimpleBeanTypes(@NotNull SpringBean bean) {
        PsiClass aClass;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getSimpleBeanTypes"));
        }
        HashSet psiTypes = ContainerUtil.newHashSet((int)1);
        if (bean instanceof AbstractDomSpringBean && (aClass = ((AbstractDomSpringBean)bean).getClassAttributeValue()) != null) {
            psiTypes.add(PsiTypesUtil.getClassType((PsiClass)aClass));
            if (SpringFactoryBeansManager.getInstance().isFactoryBeanClass(aClass)) {
                ContainerUtil.addAll((Collection)psiTypes, (Object[])SpringFactoryBeansManager.getInstance().getObjectTypes(aClass, (CommonSpringBean)bean));
            }
        }
        HashSet hashSet = psiTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelIndexProcessor", "getSimpleBeanTypes"));
        }
        return hashSet;
    }

    private static boolean hasClassAttribute(SpringBean bean) {
        return DomUtil.hasXml((DomElement)bean.getClazz());
    }

    private static /* synthetic */ boolean lambda$getComponentScans$1(List scans, SpringBeanPointer pointer) {
        CommonSpringBean bean = pointer.getSpringBean();
        if (bean instanceof SpringBeansPackagesScan) {
            scans.add((SpringBeansPackagesScan)bean);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getCustomBeanCandidates$0(String key, List result, SpringBeanPointer pointer) {
        CommonSpringBean bean = pointer.getSpringBean();
        if (!(bean instanceof CustomBeanWrapper)) {
            return true;
        }
        CustomBeanWrapper wrapper = (CustomBeanWrapper)bean;
        if (!wrapper.isParsed()) {
            XmlTag tag = wrapper.getXmlTag();
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!key.equals(attribute.getDisplayValue())) continue;
                result.add(tag);
                return true;
            }
        }
        return true;
    }

    private class ByClassCachingProcessor
    extends CachingProcessor<SpringModelSearchParameters.BeanClass, SpringBeanSearchParameters.BeanClass> {
        private List<QueryExecutor<SpringBeanPointer, SpringBeanSearchParameters.BeanClass>> myExecutors;

        private ByClassCachingProcessor(QueryExecutor<SpringBeanPointer, SpringBeanSearchParameters.BeanClass> executor) {
            this.myExecutors = Collections.singletonList(executor);
        }

        @Override
        protected ExecutorsQuery<SpringBeanPointer, SpringBeanSearchParameters.BeanClass> createQuery(SpringModelSearchParameters.BeanClass params) {
            return new ExecutorsQuery((Object)LocalXmlModelIndexProcessor.this.getByClassSearchParameters(params), this.myExecutors);
        }
    }

    private static abstract class CachingProcessor<InParams extends SpringModelSearchParameters, OutParams extends SpringBeanSearchParameters> {
        private final Map<InParams, Collection<SpringBeanPointer>> myFindAllCache = new ConcurrentFactoryMap<InParams, Collection<SpringBeanPointer>>(){

            @Nullable
            protected Collection<SpringBeanPointer> create(InParams parameters) {
                ExecutorsQuery query = this.createQuery(parameters);
                SmartList results = new SmartList();
                Processor collectProcessor = Processors.cancelableCollectProcessor((Collection)results);
                query.forEach(collectProcessor);
                return results.isEmpty() ? Collections.emptyList() : results;
            }
        };
        private final Map<InParams, SpringBeanPointer> myFindFirstCache = new ConcurrentFactoryMap<InParams, SpringBeanPointer>(){

            @Nullable
            protected SpringBeanPointer create(InParams parameters) {
                return (SpringBeanPointer)this.createQuery(parameters).findFirst();
            }
        };

        private CachingProcessor() {
        }

        protected abstract ExecutorsQuery<SpringBeanPointer, OutParams> createQuery(InParams var1);

        protected boolean process(InParams params, Processor<SpringBeanPointer> processor, Set<String> activeProfiles) {
            if (processor instanceof CommonProcessors.FindFirstProcessor && !this.myFindAllCache.containsKey(params)) {
                SpringBeanPointer first = this.myFindFirstCache.get(params);
                return CachingProcessor.processBeansInActiveProfile(processor, first, activeProfiles);
            }
            for (SpringBeanPointer pointer : this.myFindAllCache.get(params)) {
                if (CachingProcessor.processBeansInActiveProfile(processor, pointer, activeProfiles)) continue;
                return false;
            }
            return true;
        }

        private static boolean processBeansInActiveProfile(Processor<SpringBeanPointer> processor, @Nullable SpringBeanPointer pointer, Set<String> activeProfiles) {
            if (pointer == null) {
                return true;
            }
            if (activeProfiles == null || activeProfiles.isEmpty()) {
                return processor.process((Object)pointer);
            }
            if (!SpringProfileUtils.isProfileAccepted((SpringProfile)pointer.getSpringBean().getProfile(), activeProfiles)) {
                return true;
            }
            return processor.process((Object)pointer);
        }
    }
}

