/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyPlaceholderFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder", "buildFoldRegions"));
        }
        if (!(root instanceof XmlFile) || quick || !JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages()) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder", "buildFoldRegions"));
            }
            return FoldingDescriptor.EMPTY;
        }
        DomFileElement fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)((XmlFile)root));
        if (fileElement == null) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder", "buildFoldRegions"));
            }
            return FoldingDescriptor.EMPTY;
        }
        final PlaceholderUtils placeholderUtils = PlaceholderUtils.getInstance();
        SmartList regions = new SmartList();
        fileElement.accept(new DomElementVisitor((List)regions){
            final /* synthetic */ List val$regions;
            {
                this.val$regions = list;
            }

            public void visitDomElement(DomElement element) {
                if (!DomUtil.hasXml((DomElement)element)) {
                    return;
                }
                if (element instanceof GenericDomValue) {
                    if (placeholderUtils.isRawTextPlaceholder((GenericDomValue)element)) {
                        XmlElement xmlElement = element.getXmlElement();
                        if (xmlElement instanceof XmlAttribute) {
                            XmlAttributeValue value = ((XmlAttribute)xmlElement).getValueElement();
                            if (value != null) {
                                ContainerUtil.addIfNotNull((Object)PropertyPlaceholderFoldingBuilder.createDescriptor((PsiElement)value), (Collection)this.val$regions);
                            }
                        } else if (xmlElement instanceof XmlTag) {
                            ContainerUtil.addIfNotNull((Object)PropertyPlaceholderFoldingBuilder.createDescriptor((PsiElement)xmlElement), (Collection)this.val$regions);
                        }
                    }
                } else {
                    element.acceptChildren((DomElementVisitor)this);
                }
            }
        });
        FoldingDescriptor[] foldingDescriptorArray = regions.isEmpty() ? FoldingDescriptor.EMPTY : regions.toArray(new FoldingDescriptor[regions.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    @Nullable
    private static FoldingDescriptor createDescriptor(final PsiElement element) {
        for (PsiReference reference : element.getReferences()) {
            if (!(reference instanceof PlaceholderPropertyReference)) continue;
            if (((PlaceholderPropertyReference)reference).multiResolve(false).length == 0) {
                return null;
            }
            return new FoldingDescriptor(element, ((PlaceholderPropertyReference)reference).getFullTextRange().shiftRight(element.getTextRange().getStartOffset())){

                @NotNull
                public Set<Object> getDependencies() {
                    PsiElement property = PropertyPlaceholderFoldingBuilder.resolveProperty(element);
                    if (property != null) {
                        PsiFile containingFile = property.getContainingFile();
                        Set set = ContainerUtil.createMaybeSingletonSet((Object)containingFile);
                        if (set == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder$2", "getDependencies"));
                        }
                        return set;
                    }
                    Set set = super.getDependencies();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder$2", "getDependencies"));
                    }
                    return set;
                }
            };
        }
        return null;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder", "getPlaceholderText"));
        }
        PsiElement element = node.getPsi();
        PsiElement property = PropertyPlaceholderFoldingBuilder.resolveProperty(element);
        String text = null;
        if (property instanceof IProperty) {
            text = ((IProperty)property).getUnescapedValue();
        }
        if (text == null) {
            return null;
        }
        return text.trim().isEmpty() ? "<empty>" : text;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder", "isCollapsedByDefault"));
        }
        return true;
    }

    @Nullable
    private static PsiElement resolveProperty(PsiElement element) {
        for (PsiReference reference : element.getReferences()) {
            ResolveResult[] results;
            if (!(reference instanceof PlaceholderPropertyReference) || (results = ((PlaceholderPropertyReference)reference).multiResolve(false)).length <= 0) continue;
            return results[0].getElement();
        }
        return null;
    }
}

