/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.el;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.el.extensions.SpringELAliasedAttributeInjectionContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringELCacheableContextVariables
extends SpringElContextsExtension {
    private static List<String> CACHE_ANNOTATIONS = Arrays.asList("org.springframework.cache.annotation.Cacheable", "org.springframework.cache.annotation.CacheEvict", "org.springframework.cache.annotation.CachePut");

    @NotNull
    public Collection<PsiMethod> getRootMethods(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getRootMethods"));
        }
        PsiAnnotation annotation = SpringELCacheableContextVariables.getCacheableAnnotationContext(context);
        if (annotation == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getRootMethods"));
            }
            return list;
        }
        PsiClass rootObjectClass = SpringELCacheableContextVariables.getRootObjectClass(annotation.getProject());
        if (rootObjectClass != null) {
            HashSet methods = ContainerUtil.newHashSet();
            for (PsiMethod psiMethod : rootObjectClass.getAllMethods()) {
                PsiClass containingClass;
                if (!psiMethod.hasModifierProperty("public") || psiMethod.isConstructor() || (containingClass = psiMethod.getContainingClass()) == null || "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
                methods.add(psiMethod);
            }
            HashSet hashSet = methods;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getRootMethods"));
            }
            return hashSet;
        }
        Collection collection = super.getRootMethods(context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getRootMethods"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getContextVariables"));
        }
        PsiAnnotation annotation = SpringELCacheableContextVariables.getCacheableAnnotationContext(context);
        if (annotation == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getContextVariables"));
            }
            return list;
        }
        List variables = ContainerUtil.newSmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
        if (method != null) {
            PsiType returnType = method.getReturnType();
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnType != null && returnTypeElement != null) {
                variables.add(new LightVariableBuilder("result", returnType, (PsiElement)returnTypeElement));
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType parameterType = parameter.getType();
                variables.add(parameter);
                variables.add(new LightVariableBuilder("a" + i, parameterType, (PsiElement)parameter));
                variables.add(new LightVariableBuilder("p" + i, parameterType, (PsiElement)parameter));
            }
        }
        ContainerUtil.addIfNotNull((Object)SpringELCacheableContextVariables.getCacheRootObject(context.getProject()), (Collection)variables);
        List list = variables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getContextVariables"));
        }
        return list;
    }

    @Nullable
    private static PsiAnnotation getCacheableAnnotationContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getCacheableAnnotationContext"));
        }
        PsiElement element = context.getContext();
        if (element == null) {
            return null;
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
        return annotation != null && SpringELCacheableContextVariables.isCacheAnnotation(annotation) ? annotation : null;
    }

    private static boolean isCacheAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "isCacheAnnotation"));
        }
        if (CACHE_ANNOTATIONS.contains(annotation.getQualifiedName())) {
            return true;
        }
        for (String cacheAnnotation : CACHE_ANNOTATIONS) {
            if (!SpringELAliasedAttributeInjectionContext.isCustomAnnotation(annotation, cacheAnnotation)) continue;
            return true;
        }
        return false;
    }

    private static PsiVariable getCacheRootObject(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getCacheRootObject"));
        }
        return (PsiVariable)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<PsiVariable>(){

            @Nullable
            public CachedValueProvider.Result<PsiVariable> compute() {
                PsiClass rootObjectClass = SpringELCacheableContextVariables.getRootObjectClass(project);
                if (rootObjectClass == null) {
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
                }
                PsiClassType type = PsiTypesUtil.getClassType((PsiClass)rootObjectClass);
                return CachedValueProvider.Result.create((Object)new LightVariableBuilder("root", (PsiType)type, (PsiElement)rootObjectClass), (Object[])new Object[]{rootObjectClass, ProjectRootManager.getInstance((Project)project)});
            }
        });
    }

    @Nullable
    private static PsiClass getRootObjectClass(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables", "getRootObjectClass"));
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.cache.interceptor.CacheExpressionRootObject", GlobalSearchScope.allScope((Project)project));
    }
}

