/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.AliasNameConverter;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

public class AliasNameConverterImpl
extends AliasNameConverter {
    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<String> genericDomValue, PsiElement element, ConvertContext context) {
        if (PlaceholderUtils.getInstance().isRawTextPlaceholder(genericDomValue)) {
            PsiReference[] psiReferenceArray = PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences(genericDomValue);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/AliasNameConverterImpl", "createReferences"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element, true){

            public PsiElement resolve() {
                return this.getElement().getParent().getParent();
            }

            @NotNull
            public Object[] getVariants() {
                SpringBeanPointer beanPointer;
                Alias alias = (Alias)genericDomValue.getParentOfType(Alias.class, false);
                if (alias != null && (beanPointer = (SpringBeanPointer)alias.getAliasedBean().getValue()) != null) {
                    Object[] objectArray = SpringBeanCoreUtils.suggestBeanNames(beanPointer.getSpringBean());
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/AliasNameConverterImpl$1", "getVariants"));
                    }
                    return objectArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/AliasNameConverterImpl$1", "getVariants"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/AliasNameConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }
}

