/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.converters.ConstructorArgIndexConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorArgIndexConverterImpl
extends ConstructorArgIndexConverter {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<Integer> index, PsiElement element, ConvertContext context) {
        MyReference ref = new MyReference(element, index, context);
        PsiReference[] psiReferenceArray = new PsiReference[]{ref};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiParameter resolve(GenericDomValue<Integer> i, @NotNull SpringBean bean) {
        int index;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl", "resolve"));
        }
        Integer value = (Integer)i.getValue();
        if (value != null && (index = value.intValue()) >= 0) {
            ResolvedConstructorArgs resolvedArgs = bean.getResolvedConstructorArgs();
            PsiMethod resolvedMethod = resolvedArgs.getResolvedMethod();
            if (resolvedMethod != null) {
                return (PsiParameter)resolvedArgs.getResolvedArgs(resolvedMethod).get(i.getParent());
            }
            List checkedMethods = resolvedArgs.getCheckedMethods();
            for (PsiMethod method : checkedMethods) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() <= index) continue;
                return parameterList.getParameters()[index];
            }
        }
        return null;
    }

    @NotNull
    public static Set<PsiParameter> multiResolve(GenericDomValue<Integer> i, SpringBean bean) {
        int index;
        HashSet set = new HashSet();
        Integer value = (Integer)i.getValue();
        if (value != null && (index = value.intValue()) >= 0) {
            ResolvedConstructorArgs resolvedArgs = bean.getResolvedConstructorArgs();
            List candidates = resolvedArgs.getCandidates();
            for (PsiMethod method : candidates) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() <= index) continue;
                set.add(parameterList.getParameters()[index]);
            }
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl", "multiResolve"));
        }
        return hashSet;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final GenericDomValue<Integer> myGenericDomValue;
        private final ConvertContext myContext;

        public MyReference(PsiElement element, GenericDomValue<Integer> index, ConvertContext context) {
            super(element);
            this.myGenericDomValue = index;
            this.myContext = context;
        }

        public PsiParameter resolve() {
            SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean((ConvertContext)this.myContext);
            if (bean == null) {
                return null;
            }
            return ConstructorArgIndexConverterImpl.resolve(this.myGenericDomValue, bean);
        }

        public boolean isSoft() {
            return true;
        }

        @NotNull
        public Object[] getVariants() {
            SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean((ConvertContext)this.myContext);
            if (bean == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl$MyReference", "getVariants"));
                }
                return EMPTY_ARRAY;
            }
            List psiMethods = bean.getInstantiationMethods();
            int maxParams = 0;
            for (PsiMethod method : psiMethods) {
                PsiParameterList parameterList = method.getParameterList();
                maxParams = Math.max(maxParams, parameterList.getParametersCount());
            }
            if (maxParams > 0) {
                Object[] objects = new Object[maxParams];
                for (int i = 0; i < maxParams; ++i) {
                    objects[i] = Integer.toString(i);
                }
                if (objects == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl$MyReference", "getVariants"));
                }
                return objects;
            }
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl$MyReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            Integer value = (Integer)this.myGenericDomValue.getValue();
            if (value != null) {
                SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean((ConvertContext)this.myContext);
                assert (bean != null);
                PsiClass clazz = bean.getInstantiationClass();
                if (clazz != null) {
                    String string = bean.getFactoryMethod().getValue() != null ? SpringBundle.message("cannot.find.factory.method.index", value, clazz.getQualifiedName()) : SpringBundle.message("cannot.find.constructor.arg.index.in.class", value, clazz.getQualifiedName());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl$MyReference", "getUnresolvedMessagePattern"));
                    }
                    return string;
                }
                String string = SpringBundle.message("cannot.find.constructor.arg.index", value);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl$MyReference", "getUnresolvedMessagePattern"));
                }
                return string;
            }
            String string = IdeBundle.message((String)"value.should.be.integer", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl$MyReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

