/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateElementQuickFixProvider<T> {
    private final String myFamilyName;

    protected CreateElementQuickFixProvider(String familyName) {
        this.myFamilyName = familyName;
    }

    public LocalQuickFix[] getQuickFixes(GenericDomValue<T> value) {
        LocalQuickFix[] localQuickFixArray;
        LocalQuickFix fix = this.getQuickFix(value);
        if (fix == null) {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        } else {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        }
        return localQuickFixArray;
    }

    @Nullable
    public LocalQuickFix getQuickFix(GenericDomValue<T> value) {
        final String elementName = this.getElementName(value);
        if (!this.isAvailable(elementName, value)) {
            return null;
        }
        final GenericDomValue copy = (GenericDomValue)value.createStableCopy();
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = CreateElementQuickFixProvider.this.getFixName(elementName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/CreateElementQuickFixProvider$1", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = CreateElementQuickFixProvider.this.myFamilyName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/CreateElementQuickFixProvider$1", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/converters/CreateElementQuickFixProvider$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/converters/CreateElementQuickFixProvider$1", "applyFix"));
                }
                String usageId = StringUtil.strip((String)StringUtil.capitalizeWords((String)CreateElementQuickFixProvider.this.myFamilyName, (boolean)true), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
                UsageTrigger.trigger((String)("spring.CreateElementQuickFix." + ConvertUsagesUtil.ensureProperKey((String)usageId)));
                CreateElementQuickFixProvider.this.apply(elementName, copy);
            }
        };
    }

    protected boolean isAvailable(String elementName, GenericDomValue<T> value) {
        return elementName != null && elementName.trim().length() > 0;
    }

    protected abstract void apply(String var1, GenericDomValue<T> var2);

    @NotNull
    protected abstract String getFixName(String var1);

    @Nullable
    protected String getElementName(@NotNull GenericDomValue<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/converters/CreateElementQuickFixProvider", "getElementName"));
        }
        return value.getStringValue();
    }
}

