/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.custom.ParseCustomBeanIntention;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParseCustomBeanQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    ParseCustomBeanQuickFixProvider() {
    }

    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        String parseBeanId;
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider", "getQuickFixes"));
        }
        GenericDomValue beanPointer = (GenericDomValue)context.getInvocationElement();
        String string = parseBeanId = beanId != null ? beanId : beanPointer.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)parseBeanId)) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        XmlFile file = context.getFile();
        SpringModel springModel = SpringManager.getInstance((Project)file.getProject()).getSpringModelByFile((PsiFile)file);
        if (springModel == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        Collection tags = springModel.getCustomBeanCandidates(parseBeanId);
        if (tags.isEmpty()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        List<LocalQuickFix> list = Collections.singletonList(new TryParsingCustomBeansFix(tags));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider", "getQuickFixes"));
        }
        return list;
    }

    private static class TryParsingCustomBeansFix
    implements LocalQuickFix,
    IntentionAction {
        private final Collection<XmlTag> myTags;

        private TryParsingCustomBeansFix(Collection<XmlTag> tags) {
            this.myTags = tags;
        }

        @NotNull
        public String getText() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix", "getText"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix", "invoke"));
            }
            ParseCustomBeanIntention.invokeCustomBeanParsers(project, this.myTags);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("try.parsing.custom.beans", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix", "applyFix"));
            }
            throw new UnsupportedOperationException("Method applyFix is not yet implemented in " + this.getClass().getName());
        }
    }
}

