/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.impl.PageflowModelImpl;
import com.intellij.seam.model.xml.PageflowModel;
import com.intellij.seam.model.xml.pageflow.PageflowDefinition;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ModuleContentRootSearchScope;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageflowModelFactory
extends DomModelFactory<PageflowDefinition, PageflowModel, PsiElement> {
    public PageflowModelFactory(Project project) {
        super(PageflowDefinition.class, project, "pageflow");
    }

    protected List<PageflowModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/model/xml/PageflowModelFactory", "computeAllModels"));
        }
        ArrayList<PageflowModel> models = new ArrayList<PageflowModel>();
        ModuleContentRootSearchScope moduleContentScope = new ModuleContentRootSearchScope(module);
        Collection pageflowlFiles = DomService.getInstance().getDomFileCandidates(PageflowDefinition.class, module.getProject(), (GlobalSearchScope)moduleContentScope);
        for (VirtualFile pageflowlFile : pageflowlFiles) {
            PageflowModel pageflowModel;
            PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(pageflowlFile);
            if (!(file instanceof XmlFile) || (pageflowModel = this.computeModel((XmlFile)file, module)) == null) continue;
            models.add(pageflowModel);
        }
        return models;
    }

    @Nullable
    public PageflowModel getModelByConfigFile(@Nullable XmlFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        return this.computeModel(psiFile, ModuleUtil.findModuleForPsiElement((PsiElement)psiFile));
    }

    protected PageflowModel computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/seam/model/xml/PageflowModelFactory", "computeModel"));
        }
        if (module == null) {
            return null;
        }
        return this.createSingleModel(psiFile, module);
    }

    @Nullable
    private PageflowModel createSingleModel(XmlFile psiFile, Module module) {
        DomFileElement componentsDomFileElement = this.getDomRoot(psiFile);
        if (componentsDomFileElement != null) {
            DomFileElement fileElement;
            HashSet<XmlFile> files = new HashSet<XmlFile>();
            files.add(psiFile);
            DomFileElement domFileElement = fileElement = files.size() > 1 ? this.createMergedModelRoot(files) : componentsDomFileElement;
            if (fileElement != null) {
                return new PageflowModelImpl(module, (DomFileElement<PageflowDefinition>)fileElement, files);
            }
        }
        return null;
    }

    protected PageflowModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<PageflowDefinition> mergedModel, PageflowModel firstModel, Module module) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/seam/model/xml/PageflowModelFactory", "createCombinedModel"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/seam/model/xml/PageflowModelFactory", "createCombinedModel"));
        }
        throw new UnsupportedOperationException();
    }
}

