/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.checkoutwizard;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepCancelledException;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.UserCancelledException;
import org.jetbrains.tfsIntegration.ui.ManageWorkspacesForm;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardModel;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseLocalAndServerPathsStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseModeStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseServerPathStep;

public class ChooseWorkspaceStep
extends CheckoutWizardStep {
    public static final Object ID = new Object();
    private final ManageWorkspacesForm myManageWorkspacesForm;

    public ChooseWorkspaceStep(Project project, CheckoutWizardModel model) {
        super("Source Workspace", model);
        this.myManageWorkspacesForm = new ManageWorkspacesForm(project, false);
        this.myManageWorkspacesForm.addSelectionListener(new ManageWorkspacesForm.Listener(){

            @Override
            public void selectionChanged() {
                ChooseWorkspaceStep.this.fireStateChanged();
            }
        });
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/checkoutwizard/ChooseWorkspaceStep", "getStepId"));
        }
        return object;
    }

    public Object getNextStepId() {
        if (this.myModel.getMode() == CheckoutWizardModel.Mode.Manual) {
            return ChooseServerPathStep.ID;
        }
        return ChooseLocalAndServerPathsStep.ID;
    }

    public Object getPreviousStepId() {
        return ChooseModeStep.ID;
    }

    public boolean isComplete() {
        if (this.myModel.getMode() == CheckoutWizardModel.Mode.Manual) {
            return this.myManageWorkspacesForm.getSelectedWorkspace() != null;
        }
        return this.myManageWorkspacesForm.getSelectedServer() != null;
    }

    public void _init() {
        if (this.myModel.getMode() == CheckoutWizardModel.Mode.Manual) {
            this.setTitle("Source Workspace");
            this.myManageWorkspacesForm.setShowWorkspaces(true);
            if (this.myModel.getWorkspace() != null) {
                this.myManageWorkspacesForm.setSelectedWorkspace(this.myModel.getWorkspace());
            } else {
                this.myManageWorkspacesForm.selectFirstWorkspace();
            }
        } else {
            this.setTitle("Source Server");
            this.myManageWorkspacesForm.setShowWorkspaces(false);
            if (this.myModel.getServer() != null) {
                this.myManageWorkspacesForm.setSelectedServer(this.myModel.getServer());
            } else {
                this.myManageWorkspacesForm.selectFirstServer();
            }
        }
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        if (this.myModel.getMode() == CheckoutWizardModel.Mode.Manual) {
            WorkspaceInfo workspace = this.myManageWorkspacesForm.getSelectedWorkspace();
            if (workspace != null) {
                this.myModel.setServer(workspace.getServer());
            }
            this.myModel.setWorkspace(workspace);
            if (commitType == AbstractWizardStepEx.CommitType.Next || commitType == AbstractWizardStepEx.CommitType.Finish) {
                try {
                    workspace.loadFromServer(null, true);
                    List<WorkingFolderInfo> workingFolders = workspace.getWorkingFolders(null);
                    if (workingFolders.isEmpty()) {
                        String message = MessageFormat.format("Workspace ''{0}'' has no mappings.", workspace.getName());
                        throw new CommitStepException(message);
                    }
                    this.myModel.setServerPath(workingFolders.get(0).getServerPath());
                }
                catch (UserCancelledException e) {
                    throw new CommitStepCancelledException();
                }
                catch (TfsException e) {
                    throw new CommitStepException(e.getMessage());
                }
            }
        } else {
            ServerInfo server = this.myManageWorkspacesForm.getSelectedServer();
            this.myModel.setServer(server);
            if (commitType == AbstractWizardStepEx.CommitType.Next || commitType == AbstractWizardStepEx.CommitType.Finish) {
                try {
                    TfsServerConnectionHelper.ensureAuthenticated(this.myManageWorkspacesForm.getContentPane(), server.getUri(), true);
                }
                catch (UserCancelledException e) {
                    throw new CommitStepCancelledException();
                }
                catch (TfsException e) {
                    throw new CommitStepException(e.getMessage());
                }
            }
        }
    }

    public JComponent getComponent() {
        return this.myManageWorkspacesForm.getContentPane();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myManageWorkspacesForm.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        if (this.myModel.getMode() == CheckoutWizardModel.Mode.Manual) {
            return "reference.checkoutTFS.sourceworkspace";
        }
        return "reference.checkoutTFS.sourceserver";
    }
}

