/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.javascript.debugger.GlobalEvaluator;
import com.jetbrains.javascript.debugger.GlobalVariablesHolder;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler$Companion$WhenMappings;
import com.jetbrains.javascript.debugger.LocalVariablesHolder;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerConsoleExecuteActionHandler;", "Lcom/intellij/execution/console/BaseConsoleExecuteActionHandler;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "globalVariables", "Lcom/jetbrains/javascript/debugger/GlobalVariablesHolder;", "getGlobalVariables", "()Lcom/jetbrains/javascript/debugger/GlobalVariablesHolder;", "localVariables", "Lcom/jetbrains/javascript/debugger/LocalVariablesHolder;", "getLocalVariables", "()Lcom/jetbrains/javascript/debugger/LocalVariablesHolder;", "variableWillBeAdded", "", "beforeExecution", "", "console", "Lcom/intellij/execution/console/LanguageConsoleView;", "execute", "text", "", "isEmptyCommandExecutionAllowed", "Companion", "JavaScriptDebugger"})
public final class JavaScriptDebuggerConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler {
    @NotNull
    private final LocalVariablesHolder localVariables;
    @NotNull
    private final GlobalVariablesHolder globalVariables;
    private boolean variableWillBeAdded;
    private static final Key<Object> STRING_KEY;
    private static final Key<Object> NUMBER_KEY;
    private static final Key<Object> KEYWORD_KEY;
    public static final Companion Companion;

    @NotNull
    public final LocalVariablesHolder getLocalVariables() {
        return this.localVariables;
    }

    @NotNull
    public final GlobalVariablesHolder getGlobalVariables() {
        return this.globalVariables;
    }

    public boolean isEmptyCommandExecutionAllowed() {
        return false;
    }

    protected void beforeExecution(@NotNull LanguageConsoleView console2) {
        Intrinsics.checkParameterIsNotNull((Object)console2, (String)"console");
        console2.getFile().accept((PsiElementVisitor)new PsiVisitors.FilteringPsiRecursiveElementWalkingVisitor(this){
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof JSVarStatement) {
                    JavaScriptDebuggerConsoleExecuteActionHandler.access$setVariableWillBeAdded$p(this.this$0, true);
                    this.stopWalking();
                } else if (!(element instanceof JSFunction)) {
                    super.visitElement(element);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    protected void execute(@NotNull String text, @NotNull LanguageConsoleView console2) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)console2, (String)"console");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)console2.getComponent());
        XDebugSession xDebugSession = (XDebugSession)XDebugSession.DATA_KEY.getData(dataContext);
        if (xDebugSession == null) {
            return;
        }
        XDebugSession session = xDebugSession;
        XDebugProcess xDebugProcess = session.getDebugProcess();
        if (xDebugProcess == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.javascript.debugger.JavaScriptDebugProcess<*>");
        }
        JavaScriptDebugProcess debugProcess = (JavaScriptDebugProcess)xDebugProcess;
        CallFrameView currentCallFrame = (CallFrameView)session.getCurrentStackFrame();
        boolean variableWillBeAdded = this.variableWillBeAdded;
        this.variableWillBeAdded = false;
        CallFrameView callFrameView = currentCallFrame;
        if (callFrameView == null || (callFrameView = callFrameView.getEvaluateContext()) == null) {
            Vm vm = debugProcess.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            if ((callFrameView = vm.getEvaluateContext()) == null) {
                Intrinsics.throwNpe();
            }
        }
        EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)callFrameView, (String)text, null, (boolean)true, (int)2, null).done((Consumer)new Consumer<EvaluateResult>(this, console2, debugProcess, text, variableWillBeAdded, currentCallFrame, session){
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
            final /* synthetic */ LanguageConsoleView $console;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;
            final /* synthetic */ String $text;
            final /* synthetic */ boolean $variableWillBeAdded;
            final /* synthetic */ CallFrameView $currentCallFrame;
            final /* synthetic */ XDebugSession $session;

            /*
             * WARNING - void declaration
             */
            public final void consume(EvaluateResult it) {
                if (it.getWasThrown()) {
                    this.$console.print("\u200c", ConsoleViewContentType.ERROR_OUTPUT);
                    GlobalEvaluator globalEvaluator = this.$debugProcess.getGlobalEvaluator();
                    Value value = it.getValue();
                    ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                    globalEvaluator.printAndStoreValueToInspect(value, this.$text, consoleViewContentType);
                    this.$console.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
                    return;
                }
                if (this.$variableWillBeAdded) {
                    if (this.$currentCallFrame == null) {
                        this.this$0.getGlobalVariables().update();
                    } else if (Intrinsics.areEqual((Object)this.$currentCallFrame, (Object)this.$session.getCurrentStackFrame())) {
                        CallFrame callFrame;
                        this.this$0.getLocalVariables().callFrame = callFrame = this.$currentCallFrame.getCallFrame();
                        Scope localScope = JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getLocalScope(callFrame);
                        if (localScope != null) {
                            void $receiver$iv;
                            Promise promise = localScope.getVariablesHost().clearCaches();
                            void v3 = $receiver$iv;
                            if (v3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                            }
                            ((Promise)v3).done((Consumer)new Consumer<Object>(this){
                                final /* synthetic */ execute.1 this$0;

                                public final void consume(Object it) {
                                    this.this$0.this$0.getLocalVariables().update();
                                    this.this$0.$debugProcess.getSession().rebuildViews();
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }).rejected((Consumer)new RejectErrorReporter(this.$session));
                        }
                    }
                }
                this.$console.print("\u200c", ConsoleViewContentType.NORMAL_OUTPUT);
                GlobalEvaluator globalEvaluator = this.$debugProcess.getGlobalEvaluator();
                Value value = it.getValue();
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)com.jetbrains.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler$Companion.access$getValueKey(JavaScriptDebuggerConsoleExecuteActionHandler.Companion, it.getValue()));
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026pe(getValueKey(it.value))");
                globalEvaluator.printAndStoreValueToInspect(value, this.$text, consoleViewContentType);
                this.$console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            {
                this.this$0 = javaScriptDebuggerConsoleExecuteActionHandler;
                this.$console = languageConsoleView;
                this.$debugProcess = javaScriptDebugProcess;
                this.$text = string;
                this.$variableWillBeAdded = bl;
                this.$currentCallFrame = callFrameView;
                this.$session = xDebugSession;
            }
        }).rejected((Consumer)new Consumer<Throwable>(console2){
            final /* synthetic */ LanguageConsoleView $console;

            public final void consume(Throwable it) {
                this.$console.print("\u200c", ConsoleViewContentType.NORMAL_OUTPUT);
                String string = it.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.$console.print(string, ConsoleViewContentType.ERROR_OUTPUT);
                this.$console.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
            }
            {
                this.$console = languageConsoleView;
            }
        });
    }

    public JavaScriptDebuggerConsoleExecuteActionHandler(final @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(true);
        this.globalVariables = new GlobalVariablesHolder((DebuggerViewSupport)debugProcess.getDebuggerViewSupport());
        if (!ApplicationManager.getApplication().isUnitTestMode() && SystemProperties.getBooleanProperty((String)"js.debugger.load.global.variables.on.start", (boolean)true)) {
            debugProcess.getConnection().executeOnStart(new Runnable(){

                @Override
                public final void run() {
                    this.getGlobalVariables().update();
                }
            });
        }
        this.localVariables = new LocalVariablesHolder((DebuggerViewSupport)debugProcess.getDebuggerViewSupport());
        debugProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                this.updateConsoleContext();
            }

            private final void updateConsoleContext() {
                this.getLocalVariables().callFrame = null;
                XDebugSession session = debugProcess.getSession();
                ConsoleView consoleView = session.getConsoleView();
                if (!(consoleView instanceof LanguageConsoleView)) {
                    consoleView = null;
                }
                LanguageConsoleView languageConsoleView = (LanguageConsoleView)consoleView;
                if (languageConsoleView == null) {
                    return;
                }
                LanguageConsoleView consoleView2 = languageConsoleView;
                XSourcePosition position = session.getCurrentPosition();
                ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(session, consoleView2, position){
                    final /* synthetic */ XDebugSession $session;
                    final /* synthetic */ LanguageConsoleView $consoleView;
                    final /* synthetic */ XSourcePosition $position;

                    public final void invoke() {
                        if (this.$session.getProject().isDisposed()) {
                            return;
                        }
                        PsiFile psiFile = this.$consoleView.getFile();
                        if (psiFile == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl");
                        }
                        JSExpressionCodeFragmentImpl consolePsiFile = (JSExpressionCodeFragmentImpl)psiFile;
                        if (this.$position == null || this.$position.getOffset() < 0) {
                            consolePsiFile.setContext((PsiElement)null);
                        } else {
                            PsiFile contextPsiFile;
                            PsiFile psiFile2 = contextPsiFile = PsiManager.getInstance((Project)this.$session.getProject()).findFile(this.$position.getFile());
                            PsiElement context = psiFile2 != null ? psiFile2.findElementAt(this.$position.getOffset()) : null;
                            consolePsiFile.setContext(context);
                        }
                    }
                    {
                        this.$session = xDebugSession;
                        this.$consoleView = languageConsoleView;
                        this.$position = xSourcePosition;
                        super(0);
                    }
                }));
            }

            public void sessionStopped() {
                this.updateConsoleContext();
            }

            public void sessionResumed() {
                this.updateConsoleContext();
            }

            public void sessionPaused() {
                this.updateConsoleContext();
            }
        });
    }

    static {
        Companion = new Companion(null);
        STRING_KEY = new Key("JS_DEBUG_STRING");
        NUMBER_KEY = new Key("JS_DEBUG_NUMBER");
        KEYWORD_KEY = new Key("JS_DEBUG_KEYWORD");
        ConsoleViewContentType.registerNewConsoleViewType((Key)JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getSTRING_KEY(), (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        ConsoleViewContentType.registerNewConsoleViewType((Key)JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getNUMBER_KEY(), (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        ConsoleViewContentType.registerNewConsoleViewType((Key)JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getKEYWORD_KEY(), (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    }

    public static final /* synthetic */ boolean access$getVariableWillBeAdded$p(JavaScriptDebuggerConsoleExecuteActionHandler $this) {
        return $this.variableWillBeAdded;
    }

    public static final /* synthetic */ void access$setVariableWillBeAdded$p(JavaScriptDebuggerConsoleExecuteActionHandler $this, boolean bl) {
        $this.variableWillBeAdded = bl;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u000f\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0001 \u0010*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00040\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001c\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerConsoleExecuteActionHandler$Companion;", "", "()V", "KEYWORD_KEY", "Lcom/intellij/openapi/util/Key;", "getKEYWORD_KEY", "()Lcom/intellij/openapi/util/Key;", "NUMBER_KEY", "getNUMBER_KEY", "STRING_KEY", "getSTRING_KEY", "getLocalScope", "Lorg/jetbrains/debugger/Scope;", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "getValueKey", "kotlin.jvm.PlatformType", "value", "Lorg/jetbrains/debugger/values/Value;", "JavaScriptDebugger"})
    public static final class Companion {
        private final Key<Object> getSTRING_KEY() {
            return STRING_KEY;
        }

        private final Key<Object> getNUMBER_KEY() {
            return NUMBER_KEY;
        }

        private final Key<Object> getKEYWORD_KEY() {
            return KEYWORD_KEY;
        }

        @Nullable
        public final Scope getLocalScope(@NotNull CallFrame callFrame) {
            Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
            for (Scope scope : callFrame.getVariableScopes()) {
                if (!Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.LOCAL)) continue;
                return scope;
            }
            return null;
        }

        private final Key<Object> getValueKey(Value value) {
            Key<Object> key;
            switch (JavaScriptDebuggerConsoleExecuteActionHandler$Companion$WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
                case 1: {
                    key = this.getSTRING_KEY();
                    break;
                }
                case 2: {
                    key = this.getNUMBER_KEY();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    key = this.getKEYWORD_KEY();
                    break;
                }
                default: {
                    key = ProcessOutputTypes.STDOUT;
                }
            }
            return key;
        }

        private Companion() {
        }

        public static final /* synthetic */ Key access$getValueKey(Companion $this, @NotNull Value value) {
            return $this.getValueKey(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

