/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.codeInsight.lookup.LookupElement;
import gnu.trove.THashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

abstract class VariablesHolder {
    protected final DebuggerViewSupport viewSupport;
    protected final ArrayList<LookupElement> lookupElements;
    protected final THashMap<String, String> nameToPsiTypeName;

    protected VariablesHolder(@NotNull DebuggerViewSupport viewSupport) {
        if (viewSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSupport", "com/jetbrains/javascript/debugger/VariablesHolder", "<init>"));
        }
        this.lookupElements = new ArrayList();
        this.nameToPsiTypeName = new THashMap();
        this.viewSupport = viewSupport;
    }

    @Nullable
    protected static String backendTypeNameToPsiTypeName(@Nullable Value value) {
        if (value == null) {
            return "*";
        }
        if (value instanceof ObjectValue) {
            return VariableViewKt.getClassName((ObjectValue)((ObjectValue)value));
        }
        switch (value.getType()) {
            case OBJECT: {
                return "Object";
            }
            case NUMBER: {
                return "number";
            }
            case STRING: {
                return "string";
            }
            case FUNCTION: {
                return "function";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case ARRAY: {
                return "Array";
            }
            case NODE: {
                return "Object";
            }
            case UNDEFINED: {
                return "undefined";
            }
            case NULL: {
                return "null";
            }
        }
        return null;
    }

    @Nullable
    public String getTypeByName(@NotNull String variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/jetbrains/javascript/debugger/VariablesHolder", "getTypeByName"));
        }
        return (String)this.nameToPsiTypeName.get((Object)variableName);
    }

    protected abstract AsyncValueLoader<?> getVariablesLoader();

    public void update() {
        this.getVariablesLoader().markDirty();
        this.getVariablesLoader().get();
    }
}

