/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.javascript.folding.JavaScriptFoldingBuilder;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.StringTokenizer;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptFoldingBuilder
extends JavaScriptFoldingBuilder {
    protected ASTNode appendDescriptors(ASTNode node, Document document, List<FoldingDescriptor> descriptors) {
        if (node.getElementType() == CoffeeScriptTokenTypes.BLOCK_COMMENT && node.getTextLength() > 1) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        return super.appendDescriptors(node, document, descriptors);
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/editor/CoffeeScriptFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/coffeescript/editor/CoffeeScriptFoldingBuilder", "getLanguagePlaceholderText"));
        }
        IElementType type = node.getElementType();
        if (type == CoffeeScriptTokenTypes.BLOCK_COMMENT) {
            String text = node.getText();
            StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
            String firstLine = "";
            if (tokenizer.countTokens() > 2) {
                tokenizer.nextToken();
                firstLine = tokenizer.nextToken();
                firstLine = StringUtil.replace((String)firstLine.trim(), (String)"*", (String)"");
            }
            return "### " + firstLine + "... ###";
        }
        return super.getLanguagePlaceholderText(node, range);
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/editor/CoffeeScriptFoldingBuilder", "isRegionCollapsedByDefault"));
        }
        return false;
    }

    public String getBlockPlaceholderText() {
        return "...";
    }

    @NotNull
    protected String getFoldedTestByProperty(JSProperty candidate) {
        String string = "\"" + candidate.getName() + "\": " + candidate.getValue().getText() + "...";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/editor/CoffeeScriptFoldingBuilder", "getFoldedTestByProperty"));
        }
        return string;
    }
}

