/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import com.intellij.tools.FilterInfo;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.lang.psi.CoffeeScriptFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(PsiFile file) {
        return file instanceof CoffeeScriptFile;
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(CoffeeScriptLanguage.INSTANCE.getDisplayName());
        options.setDescription("Compiles .coffee files into .js files");
        options.setFileExtension("coffee");
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setArguments("--compile $" + new FileNameMacro().getName() + "$");
        options.setOutput("$" + new FileNameWithoutExtension().getName() + "$.js");
        options.setOutputFilters(new FilterInfo[]{new FilterInfo("$FILE_PATH$:$LINE$:$COLUMN$: $MESSAGE$$", "coffee", "coffee error format")});
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/watcher/CoffeeTaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void configureWithLastOptions(TaskOptions options, @Nullable TaskOptions defaultOptions) {
        super.configureWithLastOptions(options, defaultOptions);
        if (defaultOptions != null) {
            options.setArguments(defaultOptions.getArguments());
            options.setOutput(defaultOptions.getOutput());
            options.setOutputFromStdout(defaultOptions.isOutputFromStdout());
        }
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/coffeescript/watcher/CoffeeTaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/coffeescript/watcher/CoffeeTaskConsumer", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        String programPath = CoffeeTaskConsumer.findExecutableInPath((String)(SystemInfo.isWindows ? "coffee.cmd" : "coffee"));
        options.setProgram(programPath);
        options.setArguments("--map " + options.getArguments());
        String fileNameWithoutExtensionMacroName = new FileNameWithoutExtension().getName();
        options.setOutput(options.getOutput() + ":$" + fileNameWithoutExtensionMacroName + "$.map:$" + fileNameWithoutExtensionMacroName + "$.js.map");
    }
}

