/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repositoryv2.IdDisplay;
import com.android.sdklib.repositoryv2.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.avdmanager.SystemImageList;
import com.android.tools.idea.avdmanager.SystemImageListModel;
import com.android.tools.idea.avdmanager.SystemImagePreview;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.base.Objects;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ListTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSystemImageStep
extends DynamicWizardStepWithDescription
implements SystemImageList.SystemImageSelectionListener,
SystemImageListModel.StatusIndicator {
    private SystemImageList myRecommendedImageList;
    private JPanel myPanel;
    private SystemImagePreview mySystemImagePreview;
    private JBTabbedPane myTabPane;
    private SystemImageList myX86ImageList;
    private SystemImageList myOtherImageList;
    private JBLabel myStatusLabel;
    private JButton myRefreshButton;
    private AsyncProcessIcon myAsyncIcon;
    private Device myCurrentDevice;
    private SystemImageListModel myModel;

    public ChooseSystemImageStep(@Nullable Project project, @Nullable Disposable parentDisposable) {
        super(parentDisposable);
        this.$$$setupUI$$$();
        this.myModel = new SystemImageListModel(project, this);
        this.setupImageLists();
        this.setBodyComponent(this.myPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), this.createStepBody());
        this.myRefreshButton.setIcon(AllIcons.Actions.Refresh);
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseSystemImageStep.this.myModel.refreshImages(true);
            }
        });
        this.myTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ChooseSystemImageStep.this.previewCurrentTab();
            }
        });
    }

    @NotNull
    private static SystemImageClassification getClassification(@NotNull SystemImageDescription image) {
        boolean isAvdIntel;
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getClassification"));
        }
        Abi abi = Abi.getEnum((String)image.getAbiType());
        boolean bl = isAvdIntel = abi == Abi.X86 || abi == Abi.X86_64;
        if (!isAvdIntel) {
            SystemImageClassification systemImageClassification = SystemImageClassification.OTHER;
            if (systemImageClassification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getClassification"));
            }
            return systemImageClassification;
        }
        int apiLevel = image.getVersion().getApiLevel();
        if (apiLevel == 21) {
            SystemImageClassification systemImageClassification = SystemImageClassification.X86;
            if (systemImageClassification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getClassification"));
            }
            return systemImageClassification;
        }
        if (AvdWizardConstants.TAGS_WITH_GOOGLE_API.contains(image.getTag())) {
            SystemImageClassification systemImageClassification = SystemImageClassification.RECOMMENDED;
            if (systemImageClassification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getClassification"));
            }
            return systemImageClassification;
        }
        SystemImageClassification systemImageClassification = SystemImageClassification.X86;
        if (systemImageClassification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getClassification"));
        }
        return systemImageClassification;
    }

    private void setupImageLists() {
        this.setupImageList(this.myRecommendedImageList);
        this.setupImageList(this.myX86ImageList);
        this.setupImageList(this.myOtherImageList);
        this.setImageListFilters();
    }

    private void setupImageList(@NotNull SystemImageList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "setupImageList"));
        }
        list.setModel(this.myModel);
        list.addSelectionListener(this);
        list.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
    }

    private void setImageListFilters() {
        this.myRecommendedImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.RECOMMENDED));
        this.myX86ImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.X86));
        this.myOtherImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.OTHER));
    }

    public static boolean systemImageMatchesDevice(@Nullable SystemImageDescription image, @Nullable Device device) {
        if (device == null || image == null) {
            return false;
        }
        String deviceTagId = device.getTagId();
        IdDisplay imageTag = image.getTag();
        if (deviceTagId == null || deviceTagId.equals(SystemImage.DEFAULT_TAG.getId())) {
            return imageTag.equals((Object)SystemImage.DEFAULT_TAG) || !imageTag.equals((Object)AvdWizardConstants.TV_TAG) && !imageTag.equals((Object)AvdWizardConstants.WEAR_TAG);
        }
        return deviceTagId.equals(imageTag.getId());
    }

    @Override
    public boolean validate() {
        return this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY) != null;
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.getNotNull(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, false) == false || !this.myState.containsKey(AvdWizardConstants.SYSTEM_IMAGE_KEY);
    }

    @Override
    public void onEnterStep() {
        String oldTag;
        super.onEnterStep();
        Device newDevice = this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        String newTag = newDevice == null ? null : newDevice.getTagId();
        String string = oldTag = this.myCurrentDevice == null ? null : this.myCurrentDevice.getTagId();
        if (!Objects.equal((Object)newTag, (Object)oldTag)) {
            this.myState.remove(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        }
        this.myCurrentDevice = newDevice;
        SystemImageDescription selectedImage = this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        this.myModel.refreshLocalImagesSynchronously();
        this.myModel.refreshImages(false);
        this.setSelectedImage(selectedImage);
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Choose System Image Step" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getStepName"));
        }
        return "Choose System Image Step";
    }

    @Override
    public void onSystemImageSelected(@Nullable SystemImageDescription systemImage) {
        this.mySystemImagePreview.setImage(systemImage);
        if (systemImage != null && !systemImage.isRemote()) {
            this.myState.put(AvdWizardConstants.SYSTEM_IMAGE_KEY, systemImage);
        } else {
            this.myState.remove(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        }
    }

    private void setSelectedImage(@Nullable SystemImageDescription image) {
        if (image != null) {
            SystemImageClassification classification = ChooseSystemImageStep.getClassification(image);
            switch (classification) {
                case RECOMMENDED: {
                    this.myRecommendedImageList.setSelectedImage(image);
                    this.myTabPane.setSelectedIndex(0);
                    break;
                }
                case X86: {
                    this.myX86ImageList.setSelectedImage(image);
                    this.myTabPane.setSelectedIndex(1);
                    break;
                }
                default: {
                    this.myOtherImageList.setSelectedImage(image);
                    this.myTabPane.setSelectedIndex(2);
                }
            }
        }
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("System Image" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getStepTitle"));
        }
        return "System Image";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return "Select a system image";
    }

    @Override
    public void onRefreshStart(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "onRefreshStart"));
        }
        this.myStatusLabel.setText(message);
        this.myRefreshButton.setEnabled(false);
        this.myAsyncIcon.setVisible(true);
    }

    @Override
    public void onRefreshDone(@NotNull String message, boolean partlyDownloaded) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "onRefreshDone"));
        }
        this.myStatusLabel.setText(message);
        this.myRefreshButton.setEnabled(true);
        this.myAsyncIcon.setVisible(false);
        this.myRecommendedImageList.restoreSelection(partlyDownloaded);
        this.myX86ImageList.restoreSelection(partlyDownloaded);
        this.myOtherImageList.restoreSelection(partlyDownloaded);
        this.previewCurrentTab();
    }

    private void previewCurrentTab() {
        switch (this.myTabPane.getSelectedIndex()) {
            case 0: {
                this.myRecommendedImageList.makeListCurrent();
                this.mySystemImagePreview.showExplanationForRecommended(true);
                break;
            }
            case 1: {
                this.myX86ImageList.makeListCurrent();
                this.mySystemImagePreview.showExplanationForRecommended(false);
                break;
            }
            default: {
                this.myOtherImageList.makeListCurrent();
                this.mySystemImagePreview.showExplanationForRecommended(false);
            }
        }
    }

    private void createUIComponents() {
        this.myAsyncIcon = new AsyncProcessIcon("refresh images");
        this.myRecommendedImageList = new SystemImageList();
        this.myX86ImageList = new SystemImageList();
        this.myOtherImageList = new SystemImageList();
        this.mySystemImagePreview = new SystemImagePreview(this.getDisposable());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JButton jButton;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        SystemImagePreview systemImagePreview = this.mySystemImagePreview;
        JComponent jComponent = systemImagePreview.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 1, 2, 1, 4, 2, 0, 3, null, new Dimension(360, -1), new Dimension(360, -1)));
        this.myTabPane = jBTabbedPane = new JBTabbedPane();
        jPanel.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Recommended", null, jPanel2, null);
        SystemImageList systemImageList = this.myRecommendedImageList;
        jPanel2.add((Component)systemImageList, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("x86 Images", null, jPanel3, null);
        SystemImageList systemImageList2 = this.myX86ImageList;
        jPanel3.add((Component)systemImageList2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Other Images", null, jPanel4, null);
        SystemImageList systemImageList3 = this.myOtherImageList;
        jPanel4.add((Component)systemImageList3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, new Dimension(54, 10), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myRefreshButton = jButton = new JButton();
        jButton.setText("");
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/nele/preview.png")));
        jPanel5.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStatusLabel = jBLabel = new JBLabel();
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myAsyncIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class ClassificationRowFilter
    extends RowFilter<ListTableModel<SystemImageDescription>, Integer> {
        private final SystemImageClassification myClassification;

        public ClassificationRowFilter(SystemImageClassification classification) {
            if (classification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classification", "com/android/tools/idea/avdmanager/ChooseSystemImageStep$ClassificationRowFilter", "<init>"));
            }
            this.myClassification = classification;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ListTableModel<SystemImageDescription>, ? extends Integer> entry) {
            SystemImageDescription image = (SystemImageDescription)ChooseSystemImageStep.this.myModel.getRowValue(entry.getIdentifier());
            return ChooseSystemImageStep.getClassification(image) == this.myClassification && ChooseSystemImageStep.systemImageMatchesDevice(image, ChooseSystemImageStep.this.myCurrentDevice) && this.versionSupported(image);
        }

        private boolean versionSupported(@NotNull SystemImageDescription image) {
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/avdmanager/ChooseSystemImageStep$ClassificationRowFilter", "versionSupported"));
            }
            return image.getVersion().getApiLevel() != 15;
        }
    }

    private static enum SystemImageClassification {
        RECOMMENDED,
        X86,
        OTHER;

    }
}

