/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.google.common.collect.Sets;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidDebuggerImplBase<S extends AndroidDebuggerState>
implements AndroidDebugger<S> {
    private Set<XBreakpointType<?, ?>> mySupportedBreakpointTypes;
    private final Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeClasses;

    protected AndroidDebuggerImplBase(Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeClasses) {
        this.breakpointTypeClasses = breakpointTypeClasses;
    }

    @Override
    @NotNull
    public synchronized Set<XBreakpointType<?, ?>> getSupportedBreakpointTypes() {
        if (this.mySupportedBreakpointTypes == null) {
            XDebuggerUtil debuggerUtil = XDebuggerUtil.getInstance();
            this.mySupportedBreakpointTypes = Sets.newHashSet();
            for (Class<? extends XBreakpointType<?, ?>> clazz : this.breakpointTypeClasses) {
                this.mySupportedBreakpointTypes.add(debuggerUtil.findBreakpointType(clazz));
            }
        }
        Set<XBreakpointType<?, ?>> set = this.mySupportedBreakpointTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getSupportedBreakpointTypes"));
        }
        return set;
    }
}

