/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.codeInsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.Template;
import com.intellij.javascript.testFramework.codeInsight.JsCallTemplateContextProvider;
import com.intellij.javascript.testFramework.codeInsight.MethodTemplateLookupElement;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FilteringCompletionContributor
extends CompletionContributor {
    public FilteringCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor$1", "addCompletions"));
                }
                List providers = FilteringCompletionContributor.filterContextProviders(result.getPrefixMatcher().getPrefix(), parameters);
                Ref firstSorterRef = Ref.create(null);
                result.runRemainingContributors(parameters, completionResult -> {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor$1", "lambda$addCompletions$0"));
                    }
                    LookupElement element = completionResult.getLookupElement();
                    if (!FilteringCompletionContributor.canWeDoBetter(element, providers)) {
                        result.passResult(completionResult);
                        if (firstSorterRef.isNull()) {
                            firstSorterRef.set((Object)completionResult.getSorter());
                        }
                    }
                }, true);
                CompletionSorter firstSorter = (CompletionSorter)firstSorterRef.get();
                CompletionResultSet newResult = firstSorter != null ? result.withRelevanceSorter(firstSorter) : result;
                FilteringCompletionContributor.fillCallTemplateVariants(newResult, providers);
            }
        });
    }

    @NotNull
    private static List<JsCallTemplateContextProvider> filterContextProviders(@NotNull String prefix, @NotNull CompletionParameters parameters) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor", "filterContextProviders"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor", "filterContextProviders"));
        }
        List list = ContainerUtil.filter((Object[])JsCallTemplateContextProvider.EP_NAME.getExtensions(), contextProvider -> {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor", "lambda$filterContextProviders$0"));
            }
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor", "lambda$filterContextProviders$0"));
            }
            if (!contextProvider.getCalledFunctionName().startsWith(prefix)) {
                return false;
            }
            return contextProvider.isInContext(parameters);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor", "filterContextProviders"));
        }
        return list;
    }

    private static boolean canWeDoBetter(@NotNull LookupElement lookupElement, List<JsCallTemplateContextProvider> providers) {
        if (lookupElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupElement", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor", "canWeDoBetter"));
        }
        String lookupString = lookupElement.getLookupString();
        return ContainerUtil.or(providers, contextProvider -> contextProvider.getCalledFunctionName().equals(lookupString));
    }

    private static void fillCallTemplateVariants(@NotNull CompletionResultSet result, @NotNull List<JsCallTemplateContextProvider> providers) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor", "fillCallTemplateVariants"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/javascript/testFramework/codeInsight/FilteringCompletionContributor", "fillCallTemplateVariants"));
        }
        for (final JsCallTemplateContextProvider provider : providers) {
            final String expectedCallFunctionName = provider.getCalledFunctionName();
            Template template = provider.getTemplate();
            MethodTemplateLookupElement item = new MethodTemplateLookupElement(expectedCallFunctionName, template){

                @Override
                public void renderElement(LookupElementPresentation presentation) {
                    presentation.setItemText(expectedCallFunctionName);
                    presentation.setTailText(provider.getTailText(), true);
                    presentation.setTypeText(provider.getTypeText());
                }
            };
            result.addElement((LookupElement)item);
        }
    }
}

