/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ToStringBuilder;

@API(value=API.Usage.Experimental)
public class FilterResult {
    private final boolean included;
    private final Optional<String> reason;

    public static FilterResult included(String reason) {
        return new FilterResult(true, reason);
    }

    public static FilterResult excluded(String reason) {
        return new FilterResult(false, reason);
    }

    public static FilterResult includedIf(boolean included) {
        return FilterResult.includedIf(included, () -> null, () -> null);
    }

    public static FilterResult includedIf(boolean included, Supplier<String> inclusionReasonSupplier, Supplier<String> exclusionReasonSupplier) {
        return included ? FilterResult.included(inclusionReasonSupplier.get()) : FilterResult.excluded(exclusionReasonSupplier.get());
    }

    private FilterResult(boolean included, String reason) {
        this.included = included;
        this.reason = Optional.ofNullable(reason);
    }

    public boolean included() {
        return this.included;
    }

    public boolean excluded() {
        return !this.included();
    }

    public Optional<String> getReason() {
        return this.reason;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("included", (Object)this.included).append("reason", (Object)this.reason.orElse("<unknown>")).toString();
    }
}

