/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeSource {
    public static final JSTypeSource EMPTY = new JSTypeSource(null, null, SourceLanguage.JS, false);
    public static final JSTypeSource EXPLICITLY_DECLARED = new JSTypeSource(null, null, SourceLanguage.JS, true);
    public static final JSTypeSource EMPTY_TS = new JSTypeSource(null, null, SourceLanguage.TS, false);
    private final PsiFile myScope;
    private final PsiElement mySourceElement;
    private final boolean isExplicitlyDeclared;
    private final SourceLanguage myLanguage;

    public JSTypeSource(@Nullable PsiFile scope, @Nullable PsiElement sourceElement, @NotNull SourceLanguage language, boolean isExplicitlyDeclared) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/psi/types/JSTypeSource", "<init>"));
        }
        this.myScope = scope;
        this.isExplicitlyDeclared = isExplicitlyDeclared;
        this.myLanguage = language;
        this.mySourceElement = sourceElement;
    }

    @Nullable
    public PsiFile getScope() {
        return this.myScope;
    }

    @Nullable
    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }

    public boolean isExplicitlyDeclared() {
        return this.isExplicitlyDeclared;
    }

    public boolean isEcma() {
        return this.myLanguage == SourceLanguage.AS;
    }

    public boolean isTypeScript() {
        return this.myLanguage == SourceLanguage.TS;
    }

    @NotNull
    public SourceLanguage getLanguage() {
        SourceLanguage sourceLanguage = this.myLanguage;
        if (sourceLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeSource", "getLanguage"));
        }
        return sourceLanguage;
    }

    public static enum SourceLanguage {
        JS,
        AS,
        TS;

    }
}

