/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AnnotationManipulator<T> {
    public static final AnnotationManipulator<PsiModifierListOwner> PSI_MANIPULATOR = new AnnotationManipulator<PsiModifierListOwner>(){

        @Override
        public void addAnnotation(PsiModifierListOwner owner, String text, PsiAnnotation existingAnnotation) throws IncorrectOperationException {
            PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)owner.getProject()).getElementFactory().createAnnotationFromText(text, null);
            PsiModifierList list = owner.getModifierList();
            if (list != null) {
                PsiAnnotation[] annotations = list.getAnnotations();
                list.addAfter((PsiElement)annotation, annotations.length > 0 ? annotations[annotations.length - 1] : null);
            }
        }

        @Override
        public void removeAnnotation(PsiModifierListOwner owner, PsiAnnotation existingAnnotation) throws IncorrectOperationException {
            existingAnnotation.delete();
        }

        @Override
        @Nullable
        public PsiAnnotation findAnnotation(PsiModifierListOwner owner, String annotationName) {
            PsiModifierList list = owner.getModifierList();
            return list == null ? null : list.findAnnotation(annotationName);
        }

        @Override
        @NotNull
        public PsiElement getElement(PsiModifierListOwner owner) {
            PsiModifierListOwner psiModifierListOwner = owner;
            if (psiModifierListOwner == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/util/AnnotationManipulator$1", "getElement"));
            }
            return psiModifierListOwner;
        }
    };

    public void addAnnotation(T var1, String var2, PsiAnnotation var3) throws IncorrectOperationException;

    public void removeAnnotation(T var1, PsiAnnotation var2) throws IncorrectOperationException;

    @Nullable
    public PsiAnnotation findAnnotation(T var1, String var2);

    @NotNull
    public PsiElement getElement(T var1);
}

