/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jpa.model.annotations.mapping.EntityListenerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JpaProjectComponent
extends AbstractProjectComponent {
    public static final Key<CachedValue<Collection<PsiClass>>> ENTITY_LISTENER_CLASSES_KEY = Key.create((String)"ENTITY_LISTENER_CLASSES_KEY");

    public JpaProjectComponent(final Project project, PsiManager psiManager, DbPsiFacade dbPsiFacade, final DaemonCodeAnalyzer daemonCodeAnalyzer) {
        super(project);
        dbPsiFacade.addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade modificationTracker) {
                DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
                daemonCodeAnalyzer.restart();
            }
        }, (Disposable)project);
        project.putUserData(ENTITY_LISTENER_CLASSES_KEY, (Object)CachedValuesManager.getManager((Project)psiManager.getProject()).createCachedValue(() -> new CachedValueProvider.Result(JpaProjectComponent.calculateEntityListenerClasses(project), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}), false));
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("JpaProjectComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaProjectComponent", "getComponentName"));
        }
        return "JpaProjectComponent";
    }

    public static Collection<PsiClass> calculateEntityListenerClasses(Project project) {
        PsiClass annoPsiClass;
        PsiClass psiClass = annoPsiClass = DumbService.isDumb((Project)project) ? null : JavaPsiFacade.getInstance((Project)project).findClass("javax.persistence.EntityListeners", GlobalSearchScope.allScope((Project)project));
        if (annoPsiClass == null) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet();
        for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)annoPsiClass, (SearchScope)GlobalSearchScope.projectScope((Project)project)).findAll()) {
            for (JamClassAttributeElement element : (List)EntityListenerImpl.ENTITY_LISTENERS_ANNO_META.getAttribute((PsiModifierListOwner)psiMember, (JamAttributeMeta)JamClassAttributeMeta.Collection.CLASS_COLLECTION_VALUE_META)) {
                ContainerUtil.addIfNotNull((Object)element.getValue(), (Collection)result);
            }
        }
        return result;
    }
}

