/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFacetConfigurationImpl;
import com.intellij.jpa.facet.JpaFacetImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.persistence.facet.PersistenceFacetType;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.ConfigFileMetaDataRegistry;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaFacetType
extends PersistenceFacetType<JpaFacet, JpaFacetConfiguration> {
    public JpaFacetType() {
        super(JpaFacet.ID, "jpa", JpaMessages.message((String)"jpa.facet.type.presentable.name", (Object[])new Object[0]));
    }

    public static JpaFacetType getInstance() {
        return (JpaFacetType)JpaFacetType.findInstance(JpaFacetType.class);
    }

    public JpaFacetConfiguration createDefaultConfiguration() {
        ConfigFileFactory factory = ConfigFileFactory.getInstance();
        ConfigFileMetaDataRegistry metadataRegistry = factory.createMetaDataRegistry();
        metadataRegistry.registerMetaData(new ConfigFileMetaData[]{JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA});
        metadataRegistry.registerMetaData(new ConfigFileMetaData[]{JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA});
        return new JpaFacetConfigurationImpl(factory.createConfigFileInfoSet((ConfigFileMetaDataProvider)metadataRegistry));
    }

    public JpaFacet createFacet(@NotNull Module module, String name, @NotNull JpaFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jpa/facet/JpaFacetType", "createFacet"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/jpa/facet/JpaFacetType", "createFacet"));
        }
        return new JpaFacetImpl((FacetType<JpaFacet, JpaFacetConfiguration>)this, module, name, configuration, underlyingFacet);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    @Nullable
    public Icon getIcon() {
        return JavaeeIcons.JPA_ICON;
    }

    public static class JpaFrameworkDetector
    extends FacetBasedFrameworkDetector<JpaFacet, JpaFacetConfiguration> {
        public JpaFrameworkDetector() {
            super("jpa");
        }

        public FacetType<JpaFacet, JpaFacetConfiguration> getFacetType() {
            return JpaFacetType.getInstance();
        }

        protected JpaFacetConfiguration createConfiguration(Collection<VirtualFile> files) {
            JpaFacetConfiguration configuration = (JpaFacetConfiguration)this.getFacetType().createDefaultConfiguration();
            configuration.getDescriptorsConfiguration().addConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, ((VirtualFile)ContainerUtil.getFirstItem(files)).getUrl());
            return configuration;
        }

        @NotNull
        public FileType getFileType() {
            LanguageFileType languageFileType = StdFileTypes.XML;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetType$JpaFrameworkDetector", "getFileType"));
            }
            return languageFileType;
        }

        @NotNull
        public ElementPattern<FileContent> createSuitableFilePattern() {
            FileContentPattern fileContentPattern = FileContentPattern.fileContent().xmlWithRootTag("persistence");
            if (fileContentPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetType$JpaFrameworkDetector", "createSuitableFilePattern"));
            }
            return fileContentPattern;
        }
    }
}

