/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JpaValidatorBase
extends InspectionValidator {
    public JpaValidatorBase(String description) {
        super(description, JpaMessages.message((String)"progress.validating.persistence.model.text", (Object[])new Object[0]));
    }

    protected abstract boolean acceptsFacet(PersistenceFacet var1);

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/jpa/highlighting/JpaValidatorBase", "isAvailableOnScope"));
        }
        return !this.processScopeFacets(scope.getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> false));
    }

    private boolean processScopeFacets(Module[] modules, PairProcessor<Module, PersistenceFacet> processor) {
        for (Module module : modules) {
            for (final PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
                if (!this.acceptsFacet(facet) || ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return facet.getPersistenceUnits().isEmpty();
                    }
                })).booleanValue() || processor.process((Object)module, (Object)facet)) continue;
                return false;
            }
        }
        return true;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        VirtualFile[] javaFiles;
        THashSet enabledModules = new THashSet();
        THashSet enabledFacets = new THashSet();
        this.processScopeFacets(context.getCompileScope().getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> {
            enabledFacets.add(facet);
            enabledModules.add(module);
            return true;
        }));
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile javaFile : javaFiles = context.getCompileScope().getFiles((FileType)StdFileTypes.JAVA, true)) {
            Module module2 = context.getModuleByFile(javaFile);
            if (module2 == null || !enabledModules.contains((Object)module2)) continue;
            result.add(javaFile);
        }
        THashSet descriptorFiles = new THashSet();
        for (PersistenceFacet facet2 : enabledFacets) {
            for (ConfigFile configFile : facet2.getDescriptors()) {
                InspectionValidatorUtil.addDescriptor((Collection)descriptorFiles, (ConfigFile)configFile);
            }
            for (PersistencePackage unit : facet2.getPersistenceUnits()) {
                for (GenericValue value : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                    PersistenceMappings mappings = (PersistenceMappings)value.getValue();
                    if (mappings == null) continue;
                    InspectionValidatorUtil.addFile((Collection)descriptorFiles, (PsiFile)mappings.getContainingFile());
                }
            }
        }
        result.addAll(InspectionValidatorUtil.expandCompileScopeIfNeeded((Collection)descriptorFiles, (CompileContext)context));
        return result;
    }

    @NotNull
    public Collection<PsiElement> getDependencies(PsiFile psiFile) {
        Module module;
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiFile) || (module = ModuleUtil.findModuleForPsiElement((PsiElement)psiFile)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaValidatorBase", "getDependencies"));
            }
            return list;
        }
        Collection collection = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiElement>>(){

            public Collection<PsiElement> compute() {
                ArrayList<PsiElement> result = new ArrayList<PsiElement>();
                for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
                    if (!JpaValidatorBase.this.acceptsFacet(facet)) continue;
                    for (PersistencePackage unit : facet.getPersistenceUnits()) {
                        for (GenericValue value : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                            PersistenceMappings mappings = (PersistenceMappings)value.getValue();
                            if (mappings == null || !(mappings instanceof DomElement)) continue;
                            ContainerUtil.addIfNotNull((Object)mappings.getContainingFile(), result);
                        }
                    }
                    for (ConfigFile configFile : facet.getDescriptors()) {
                        ContainerUtil.addIfNotNull((Object)configFile.getPsiFile(), result);
                    }
                }
                return result;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaValidatorBase", "getDependencies"));
        }
        return collection;
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        THashSet result = new THashSet();
        this.processScopeFacets(context.getCompileScope().getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> {
            ContainerUtil.addAll((Collection)result, (Object[])facet.getInspectionToolClasses());
            return true;
        }));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            String inspectionName = ((Class)it.next()).getSimpleName();
            if (!"JpaQueryApiInspection".equals(inspectionName) && !"CriteriaApiResolveInspection".equals(inspectionName)) continue;
            it.remove();
        }
        Class[] classArray = (Class[])result.toArray((Object[])new Class[result.size()]);
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaValidatorBase", "getInspectionToolClasses"));
        }
        return classArray;
    }
}

