/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.xml.converters.PersistentUnitFileConverter;
import com.intellij.javaee.model.xml.persistence.mapping.EntityMappings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModuleContextProvider;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentUnitFileConverterImpl
extends PersistentUnitFileConverter
implements CustomReferenceConverter {
    public PsiFile fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)context.getReferenceXmlElement(), context);
        if (references.length == 0) {
            return null;
        }
        PsiElement element = references[references.length - 1].resolve();
        return element instanceof PsiFile ? (PsiFile)element : null;
    }

    public String toString(PsiFile t, ConvertContext context) {
        if (t == null) {
            return null;
        }
        VirtualFile virtualFile = t.getVirtualFile();
        DomElement element = context.getInvocationElement();
        XmlFile persistenceXml = DomUtil.getFile((DomElement)element);
        return PersistentUnitFileConverterImpl.getUnitRootRelativePath(virtualFile, persistenceXml);
    }

    @NotNull
    public Collection<? extends PsiFile> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl", "getVariants"));
        }
        return list;
    }

    public PsiElement resolve(PsiFile o, ConvertContext context) {
        return this.isFileAccepted(o) ? super.resolve((Object)o, context) : null;
    }

    @Nullable
    public static EntityMappings findEntityMappings(String mappingName, VirtualFile persistenceXmlVf, PsiManager psiManager, @Nullable Module module) {
        PsiFile psiFile;
        VirtualFile mappingFile = PersistentUnitFileConverterImpl.findUnitRootRelativeFile(mappingName, persistenceXmlVf, module);
        if (mappingFile != null && (psiFile = psiManager.findFile(mappingFile)) instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile;
            return (EntityMappings)JamCommonUtil.getRootElement((PsiFile)xmlFile, EntityMappings.class, (Module)module);
        }
        return null;
    }

    @Nullable
    public static VirtualFile findUnitRootRelativeFile(String mappingName, VirtualFile persistenceXmlVf, Module module) {
        VirtualFile mappingFile;
        block1: {
            PsiFileSystemItem root;
            VirtualFile file;
            VirtualFile metaInf = persistenceXmlVf == null ? null : persistenceXmlVf.getParent();
            VirtualFile persistenceUnitRootVf = metaInf == null ? null : metaInf.getParent();
            mappingFile = null;
            if (persistenceUnitRootVf == null || (mappingFile = persistenceUnitRootVf.findFileByRelativePath(mappingName)) != null || module == null) break block1;
            Iterator<PsiFileSystemItem> iterator = PersistentUnitFileConverterImpl.addDefaultRoots((Collection<PsiFileSystemItem>)new THashSet(), module.getProject(), module).iterator();
            while (iterator.hasNext() && (mappingFile = (file = (root = iterator.next()).getVirtualFile()) == null ? null : file.findFileByRelativePath(mappingName)) == null) {
            }
        }
        return mappingFile;
    }

    @Nullable
    public static String getUnitRootRelativePath(VirtualFile virtualFile, XmlFile persistenceXml) {
        if (virtualFile == null) {
            return null;
        }
        if (persistenceXml == null) {
            return virtualFile.getName();
        }
        XmlFile xmlFile = (XmlFile)persistenceXml.getOriginalFile();
        VirtualFile persistenceXmlVf = xmlFile.getVirtualFile();
        if (persistenceXmlVf == null) {
            return virtualFile.getName();
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)persistenceXml.getProject()).getFileIndex();
        VirtualFile sourceRootForFile = index.getSourceRootForFile(virtualFile);
        VirtualFile sourceRootForPersistenceXml = index.getSourceRootForFile(persistenceXmlVf);
        VirtualFile persistenceUnitRootVf = persistenceXmlVf.getParent() == null ? null : persistenceXmlVf.getParent().getParent();
        VirtualFile realRoot = sourceRootForFile == null || Comparing.equal((Object)sourceRootForPersistenceXml, (Object)sourceRootForFile) ? persistenceUnitRootVf : sourceRootForFile;
        return VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)(realRoot == null ? index.getContentRootForFile(virtualFile) : realRoot), (char)'/');
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        FileReferenceSet set = PersistentUnitFileConverterImpl.createUnitRelativeFileReferenceSet(context, s, element, offset, (Condition<PsiFile>)((Condition)psiFile -> this.isFileAccepted((PsiFile)psiFile)));
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl", "createReferences"));
        }
        return fileReferenceArray;
    }

    private boolean isFileAccepted(PsiFile file) {
        return file instanceof XmlFile && DomManager.getDomManager((Project)file.getProject()).getFileElement((XmlFile)file, EntityMappings.class) != null;
    }

    public static FileReferenceSet createUnitRelativeFileReferenceSet(final ConvertContext context, String text, final @NotNull PsiElement element, int startInElement, final Condition<PsiFile> fileFilter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl", "createUnitRelativeFileReferenceSet"));
        }
        return new FileReferenceSet(text, element, startInElement, null, true){

            protected boolean isSoft() {
                return true;
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                PsiFile containingFile = element.getContainingFile().getOriginalFile();
                VirtualFile virtualFile = containingFile.getVirtualFile();
                VirtualFile metaInf = virtualFile == null ? null : virtualFile.getParent();
                VirtualFile persistenceUnitRootVf = metaInf == null ? null : metaInf.getParent();
                THashSet result = new THashSet();
                Project project = element.getProject();
                if (persistenceUnitRootVf != null) {
                    ContainerUtil.addIfNotNull((Object)PsiManager.getInstance((Project)project).findDirectory(persistenceUnitRootVf), (Collection)result);
                }
                Collection collection = PersistentUnitFileConverterImpl.addDefaultRoots((Collection)result, context.getProject(), ModuleContextProvider.getModules((PsiFile)context.getFile()));
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl$1", "computeDefaultContexts"));
                }
                return collection;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return element1 -> {
                    boolean isFile = element1 instanceof PsiFile;
                    return isFile && fileFilter.value((Object)((PsiFile)element1));
                };
            }
        };
    }

    private static Collection<PsiFileSystemItem> addDefaultRoots(Collection<PsiFileSystemItem> result, @NotNull Project project, Module ... modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl", "addDefaultRoots"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (Module module : modules) {
            THashSet dependentModules = new THashSet();
            ModuleUtil.getDependencies((Module)module, (Set)dependentModules);
            for (Module dependency : dependentModules) {
                PersistentUnitFileConverterImpl.addModuleDefaultRoots(result, dependency, psiManager);
            }
        }
        return result;
    }

    private static void addModuleDefaultRoots(Collection<PsiFileSystemItem> result, Module module, PsiManager psiManager) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            ContainerUtil.addIfNotNull((Object)psiManager.findDirectory(root), result);
        }
        for (VirtualFile root : rootManager.getContentRoots()) {
            ContainerUtil.addIfNotNull((Object)psiManager.findDirectory(root), result);
        }
    }
}

