/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.model;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.jpa.ql.annotations.QlAnnotationVisitor;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QlModel {
    public static final QlModel EMPTY_MODEL = new QlModel(){

        @Override
        public QlEntity[] getEntities() {
            return new QlEntity[0];
        }
    };

    @Nullable
    public QlEntity findEntityByName(String text) {
        if (text != null) {
            for (QlEntity qlEntity : this.getEntities()) {
                if (!qlEntity.acceptsName(text)) continue;
                return qlEntity;
            }
        }
        return null;
    }

    public QlVisitor createAnnotationVisitor(AnnotationHolder holder) {
        return new QlAnnotationVisitor(holder);
    }

    public int getParametersCount() {
        return -1;
    }

    public abstract QlEntity[] getEntities();

    public Collection<IntentionAction> getUnresolvedReferenceQuickFixes(QlReferenceExpression referenceExpression, QlEntity entity) {
        return Collections.emptyList();
    }

    public boolean processInDbSchema(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/jpa/ql/model/QlModel", "processInDbSchema"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/jpa/ql/model/QlModel", "processInDbSchema"));
        }
        return true;
    }

    public boolean processInDbTable(@NotNull String columnName, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/jpa/ql/model/QlModel", "processInDbTable"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/jpa/ql/model/QlModel", "processInDbTable"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/jpa/ql/model/QlModel", "processInDbTable"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/jpa/ql/model/QlModel", "processInDbTable"));
        }
        return true;
    }
}

