/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class BinaryOperatorUtils {
    private static final Map<IElementType, OperatorProperties> operators = new HashMap<IElementType, OperatorProperties>(39);

    private BinaryOperatorUtils() {
    }

    public static String getOperatorText(IElementType operator) {
        if (operator == null) {
            return "";
        }
        OperatorProperties operatorProperties = operators.get(operator);
        assert (operatorProperties != null) : "Operator properties is null for " + operator;
        return operatorProperties.text;
    }

    static {
        operators.put(JSTokenTypes.LT, new OperatorProperties("<"));
        operators.put(JSTokenTypes.GT, new OperatorProperties(">"));
        operators.put(JSTokenTypes.LE, new OperatorProperties("<="));
        operators.put(JSTokenTypes.GE, new OperatorProperties(">="));
        operators.put(JSTokenTypes.EQEQ, new OperatorProperties("=="));
        operators.put(JSTokenTypes.NE, new OperatorProperties("!="));
        operators.put(JSTokenTypes.EQEQEQ, new OperatorProperties("==="));
        operators.put(JSTokenTypes.NEQEQ, new OperatorProperties("!=="));
        operators.put(JSTokenTypes.PLUS, new OperatorProperties("+"));
        operators.put(JSTokenTypes.MINUS, new OperatorProperties("-"));
        operators.put(JSTokenTypes.MULT, new OperatorProperties("*"));
        operators.put(JSTokenTypes.DIV, new OperatorProperties("/"));
        operators.put(JSTokenTypes.PERC, new OperatorProperties("%"));
        operators.put(JSTokenTypes.PLUSPLUS, new OperatorProperties("++"));
        operators.put(JSTokenTypes.MINUSMINUS, new OperatorProperties("--"));
        operators.put(JSTokenTypes.LTLT, new OperatorProperties("<<"));
        operators.put(JSTokenTypes.GTGT, new OperatorProperties(">>"));
        operators.put(JSTokenTypes.GTGTGT, new OperatorProperties(">>>"));
        operators.put(JSTokenTypes.AND, new OperatorProperties("&"));
        operators.put(JSTokenTypes.OR, new OperatorProperties("|"));
        operators.put(JSTokenTypes.XOR, new OperatorProperties("^"));
        operators.put(JSTokenTypes.EXCL, new OperatorProperties("!"));
        operators.put(JSTokenTypes.TILDE, new OperatorProperties("~"));
        operators.put(JSTokenTypes.ANDAND, new OperatorProperties("&&"));
        operators.put(JSTokenTypes.OROR, new OperatorProperties("||"));
        operators.put(JSTokenTypes.OR_OR_EQ, new OperatorProperties("||="));
        operators.put(JSTokenTypes.EQ, new OperatorProperties("="));
        operators.put(JSTokenTypes.PLUSEQ, new OperatorProperties("+="));
        operators.put(JSTokenTypes.MINUSEQ, new OperatorProperties("-="));
        operators.put(JSTokenTypes.MULTEQ, new OperatorProperties("*="));
        operators.put(JSTokenTypes.PERCEQ, new OperatorProperties("%="));
        operators.put(JSTokenTypes.LTLTEQ, new OperatorProperties("<<="));
        operators.put(JSTokenTypes.GTGTEQ, new OperatorProperties(">>="));
        operators.put(JSTokenTypes.GTGTGTEQ, new OperatorProperties(">>>="));
        operators.put(JSTokenTypes.ANDEQ, new OperatorProperties("&="));
        operators.put(JSTokenTypes.OREQ, new OperatorProperties("|="));
        operators.put(JSTokenTypes.XOREQ, new OperatorProperties("^="));
        operators.put(JSTokenTypes.DIVEQ, new OperatorProperties("/="));
        operators.put(JSTokenTypes.COMMA, new OperatorProperties(","));
        operators.put(JSTokenTypes.IS_KEYWORD, new OperatorProperties("is"));
        operators.put(JSTokenTypes.AS_KEYWORD, new OperatorProperties("as"));
        operators.put(JSTokenTypes.DELETE_KEYWORD, new OperatorProperties("delete"));
        operators.put(JSTokenTypes.TYPEOF_KEYWORD, new OperatorProperties("typeof"));
        operators.put(JSTokenTypes.VOID_KEYWORD, new OperatorProperties("void"));
        operators.put(JSTokenTypes.IN_KEYWORD, new OperatorProperties("in"));
        operators.put(JSTokenTypes.INSTANCEOF_KEYWORD, new OperatorProperties("instanceof"));
    }

    private static class OperatorProperties {
        String text;

        public OperatorProperties(@NonNls String text) {
            this.text = text;
        }
    }
}

