/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.remoteServer.util.Column;
import com.intellij.remoteServer.util.JTableWrapper;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OSEmbeddableCartridgeEditor {
    private JBTable myEmbeddableCartridgeTable = new JBTable();
    private JPanel myMainPanel;
    private List<OSEmbeddableCartridgeItem> myEmbeddableCartridges = new ArrayList<OSEmbeddableCartridgeItem>();
    private JTableWrapper<OSEmbeddableCartridgeItem, CartridgeColumnBase> myCartridgesTableWrapper = new JTableWrapper(this.myEmbeddableCartridgeTable, (Column[])new CartridgeColumnBase[]{new ActiveColumn(), new CartridgeColumn()});

    public OSEmbeddableCartridgeEditor() {
        this.myMainPanel = ToolbarDecorator.createDecorator((JTable)this.myEmbeddableCartridgeTable).createPanel();
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void setEmbeddableCartridges(String[] cartridges) {
        this.myEmbeddableCartridges = new ArrayList<OSEmbeddableCartridgeItem>();
        for (String cartridge : cartridges) {
            this.myEmbeddableCartridges.add(new OSEmbeddableCartridgeItem(cartridge));
        }
        this.myCartridgesTableWrapper.setInputRows(this.myEmbeddableCartridges);
    }

    public String[] getEmbeddableCartridges() {
        ArrayList<String> result = new ArrayList<String>();
        for (OSEmbeddableCartridgeItem cartridge : this.myEmbeddableCartridges) {
            if (!cartridge.isActive()) continue;
            result.add(cartridge.getName());
        }
        return ArrayUtil.toStringArray(result);
    }

    public void setEnabledPanel(boolean value) {
        this.myEmbeddableCartridgeTable.setEnabled(value);
        this.myMainPanel.setEnabled(value);
    }

    private static class OSEmbeddableCartridgeItem {
        private String myName;
        private boolean myActive;

        public OSEmbeddableCartridgeItem(String cartridgeName) {
            this.myName = cartridgeName;
            this.myActive = false;
        }

        public String getName() {
            return this.myName;
        }

        public void setActive(boolean active) {
            this.myActive = active;
        }

        public boolean isActive() {
            return this.myActive;
        }
    }

    private static abstract class CartridgeColumnBase
    extends Column<OSEmbeddableCartridgeItem> {
        public CartridgeColumnBase(String name) {
            super(name);
        }
    }

    private static class CartridgeColumn
    extends CartridgeColumnBase {
        public CartridgeColumn() {
            super(OSBundle.getText("OSConfigEmbeddableCartridgeEditor.column.cartridge", new Object[0]));
        }

        public Object getColumnValue(OSEmbeddableCartridgeItem row) {
            return row.getName();
        }
    }

    private static class ActiveColumn
    extends CartridgeColumnBase {
        public ActiveColumn() {
            super(OSBundle.getText("OSConfigEmbeddableCartridgeEditor.column.active", new Object[0]));
        }

        public boolean isEditable() {
            return true;
        }

        public Class<?> getValueClass() {
            return Boolean.class;
        }

        public Object getColumnValue(OSEmbeddableCartridgeItem row) {
            return row.isActive();
        }

        public void setColumnValue(OSEmbeddableCartridgeItem row, Object value) {
            row.setActive((Boolean)value);
        }

        public boolean needPack() {
            return true;
        }
    }
}

