/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections.configuration;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import org.jetbrains.annotations.NotNull;

public class AddMessageDispatcherServletInWebXmlFix
implements LocalQuickFix,
IntentionAction {
    private WebApp myWebApp;
    private String myServletName;

    public AddMessageDispatcherServletInWebXmlFix(@NotNull WebApp webApp, @NotNull String servletName) {
        if (webApp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webApp", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "<init>"));
        }
        if (servletName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servletName", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "<init>"));
        }
        this.myWebApp = webApp;
        this.myServletName = servletName;
    }

    @NotNull
    public String getName() {
        String string = SpringWebServicesBundle.message("SpringWebServicesConfigurationsInspection.register.message.dispatcher.servlet.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "invoke"));
        }
        this.doFix(project);
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix", "applyFix"));
        }
        this.doFix(project);
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    protected void doFix(Project project) {
        if (this.myWebApp != null && this.myWebApp.getContainingFile() != null) {
            new WriteCommandAction<WebApp>(project, new PsiFile[]{this.myWebApp.getContainingFile()}){

                protected void run(@NotNull Result<WebApp> webAppResult) throws Throwable {
                    if (webAppResult == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webAppResult", "com/intellij/spring/ws/inspections/configuration/AddMessageDispatcherServletInWebXmlFix$1", "run"));
                    }
                    Servlet servlet = AddMessageDispatcherServletInWebXmlFix.this.myWebApp.addServlet();
                    servlet.getServletName().setStringValue(AddMessageDispatcherServletInWebXmlFix.this.myServletName);
                    servlet.getServletClass().setStringValue("org.springframework.ws.transport.http.MessageDispatcherServlet");
                    ServletMapping servletMapping = AddMessageDispatcherServletInWebXmlFix.this.myWebApp.addServletMapping();
                    servletMapping.getServletName().setStringValue(AddMessageDispatcherServletInWebXmlFix.this.myServletName);
                    servletMapping.addUrlPattern().setStringValue("/services");
                    ServletMapping servletMapping2 = AddMessageDispatcherServletInWebXmlFix.this.myWebApp.addServletMapping();
                    servletMapping2.getServletName().setStringValue(AddMessageDispatcherServletInWebXmlFix.this.myServletName);
                    servletMapping2.addUrlPattern().setStringValue("*.wsdl");
                    SpringDomUtils.navigate((DomElement)servlet);
                }
            }.execute();
        }
    }
}

