/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web.jsr45;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DefaultJSPPositionManager;
import com.intellij.debugger.engine.PositionManagersFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.j2ee.web.jsr45.JSR45Model;
import com.intellij.j2ee.web.jsr45.JSR45ServerManager;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.openapi.project.Project;

public class JSR45ServerInstance
extends DefaultServerInstance {
    public JSR45ServerInstance(CommonModel runConfiguration) {
        super(runConfiguration);
    }

    public AppServerIntegration getIntegration() {
        return JSR45ServerManager.getInstance();
    }

    public void start(ProcessHandler processHandler) {
        super.start(processHandler);
        final CommonModel configuration = this.getCommonModel();
        final JSR45Model jsr45Model = (JSR45Model)configuration.getServerModel();
        DebuggerManager.getInstance((Project)configuration.getProject()).addDebugProcessListener(processHandler, new DebugProcessListener(){

            public void processAttached(DebugProcess process) {
                process.appendPositionManager((PositionManager)JSR45ServerInstance.createPositionManager(process, configuration, jsr45Model));
            }
        });
    }

    private static DefaultJSPPositionManager createPositionManager(DebugProcess process, CommonModel configuration, JSR45Model jsr45Model) {
        JavaeeFacet[] facets = JSR45ServerInstance.getScopeFacets((CommonModel)configuration);
        if (jsr45Model.USE_WEBSPHERE51_LINEMAPPING_MODEL) {
            return PositionManagersFactory.getInstance().createWebSphereSpecificPositionManager(process, facets, jsr45Model.JSP_PACKAGE);
        }
        return PositionManagersFactory.getInstance().createJSR45PositionManager(process, facets, jsr45Model.JSP_PACKAGE);
    }
}

