/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class MathExpr
extends Expr {
    final String mOp;

    MathExpr(Expr left, String op, Expr right) {
        super(left, right);
        this.mOp = op;
    }

    @Override
    protected String computeUniqueKey() {
        return this.addTwoWay(MathExpr.join(this.getLeft().getUniqueKey(), this.mOp, this.getRight().getUniqueKey()));
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if ("+".equals(this.mOp) && (this.getLeft().getResolvedType().isString() || this.getRight().getResolvedType().isString())) {
            return modelAnalyzer.findClass(String.class);
        }
        return modelAnalyzer.findCommonParentOf(this.getLeft().getResolvedType(), this.getRight().getResolvedType());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    public Expr getLeft() {
        return this.getChildren().get(0);
    }

    public Expr getRight() {
        return this.getChildren().get(1);
    }

    @Override
    protected KCode generateCode(boolean expand) {
        return new KCode().app("", this.getLeft().toCode(expand)).app(this.mOp, this.getRight().toCode(expand));
    }

    @Override
    public String getInvertibleError() {
        if (this.mOp.equals("%")) {
            return "The modulus operator (%) is not supported in two-way binding.";
        }
        if (this.getResolvedType().isString()) {
            return "String concatenation operator (+) is not supported in two-way binding.";
        }
        if (!this.getLeft().isDynamic()) {
            return this.getRight().getInvertibleError();
        }
        if (!this.getRight().isDynamic()) {
            return this.getLeft().getInvertibleError();
        }
        return "Arithmetic operator " + this.mOp + " is not supported with two dynamic expressions.";
    }

    private String inverseCast() {
        if (!this.getLeft().isDynamic()) {
            return this.inverseCast(this.getRight());
        }
        return this.inverseCast(this.getLeft());
    }

    private String inverseCast(Expr expr) {
        if (!expr.getResolvedType().isAssignableFrom(this.getResolvedType())) {
            return "(" + this.getResolvedType() + ")";
        }
        return null;
    }

    @Override
    public KCode toInverseCode(KCode value) {
        if (!this.isDynamic()) {
            return this.toCode();
        }
        Expr left = this.getLeft();
        Expr right = this.getRight();
        Expr constExpr = left.isDynamic() ? right : left;
        Expr varExpr = left.isDynamic() ? left : right;
        String cast = this.inverseCast();
        if (cast != null) {
            value = new KCode(cast).app("(", value).app(")");
        }
        switch (this.mOp.charAt(0)) {
            case '+': {
                return varExpr.toInverseCode(value.app(" - (", constExpr.toCode()).app(")"));
            }
            case '*': {
                return varExpr.toInverseCode(value.app(" / (", constExpr.toCode()).app(")"));
            }
            case '-': {
                if (!left.isDynamic()) {
                    return varExpr.toInverseCode(new KCode().app("(", constExpr.toCode()).app(") - (", value).app(")"));
                }
                return varExpr.toInverseCode(value.app(" + ", constExpr.toCode()));
            }
            case '/': {
                if (!left.isDynamic()) {
                    return varExpr.toInverseCode(new KCode("(").app("", constExpr.toCode()).app(") / (", value).app(")"));
                }
                return varExpr.toInverseCode(new KCode("(").app("", value).app(") * (", constExpr.toCode()).app(")"));
            }
        }
        throw new IllegalStateException("Invalid math operation is not invertible: " + this.mOp);
    }
}

