var pluginFactories: {
    [name: string]: () => LanguagePluginFactory
} = {
    typescript(): LanguagePluginFactory {
        var tsFactory = require("./typescript/ts-plugin");
        return tsFactory.typescriptLanguagePluginFactory;
    }

}

var initializedPlugin: LanguagePlugin = null;


function parseParams() {
    var result = {
        sessionId: null,
        restArgs: null,
        pluginName: null
    };
    var args = process.argv.slice(2);
    var counter = 0;

    var paramNameToPropertyName: any = {};
    paramNameToPropertyName["-id="] = 'sessionId';
    paramNameToPropertyName["-pluginName="] = 'pluginName';

    args.forEach(function (value, index, arr) {
        function isName(name) {
            return value.indexOf(name) === 0;
        }

        function getValue() {
            return value.split('=')[1];
        }

        Object.keys(paramNameToPropertyName).forEach(function (val) {
            if (isName(val)) {
                result[paramNameToPropertyName[val]] = getValue();
                counter++;
            }
        })
    });

    result.restArgs = args.slice(counter);

    return result;
}

function initAndStartListening(params: {
    sessionId: string,
    restArgs: string,
    pluginName: string}) {
    const readline: NodeJS.ReadLine = require("readline");

    const rl = readline.createInterface({
        input: process.stdin,
        output: process.stdout,
        terminal: false,
    });

    //I am not sure that we need it
    process.stdin.setEncoding('utf8');


    var expectedState: boolean = true;

    rl.on("line", (input: string) => {
        const message = input.trim();
        if (expectedState) {
            let state: PluginState = JSON.parse(message);
            if (state && state.pluginName) {
                const pluginName = state.pluginName;
                if (initializedPlugin == null) {
                    let pluginFactory = pluginFactories[pluginName]();
                    if (pluginFactory != null) {
                        try {
                            let languagePlugin = pluginFactory.create(state);
                            initializedPlugin = languagePlugin;
                            sendCommand("ready");
                        } catch (e) {
                            //initialization error
                            //ok, lets kill the process
                            let err = e.message || e.messageText;
                            sendCommand("error plugin " + pluginName + " creation: " + err + " stack: " + e.stack);
                        }
                    }
                }
                expectedState = false;
            }
        } else {
            if (initializedPlugin != null) {
                try {
                    initializedPlugin.onMessage(message);
                } catch (e) {
                    console.error(e.message + " " + e.stack);
                }
            }
        }
    });

    rl.on("close", () => {
        exitProcess();
    });

    sendCommand("ready")

    setInterval(() => {
        console.error('{"type":"heartbeat", "state":"alive"}');
    }, 30000);

    function sendCommand(command) {
        process.stdout.write(params.sessionId + ' ' + command + '\n');
    }

    function sendJson(json:string) {
        process.stdout.write(json + '\n');
    }
}


function exitProcess() {
    process.exit(0);
}

initAndStartListening(parseParams());


