let crypto = require('crypto');

type HashType = any;

/**
 * Emulating incremental compilation.
 * If file content wasn't changes we don't need recompile the file
 */
export class CompileInfoHolder {

    private _lastCompilerResult:{
        [fileName:string]:HashType
    } = {}

    private ts_impl;

    constructor(ts_impl) {
        this.ts_impl = ts_impl;
    }

    checkUpdateAndAddToCache(file:ts.SourceFile):boolean {
        if (file) {
            let fileName = this.ts_impl.normalizePath(file.fileName);
            let newHash = calcHash(file.text);
            let oldHash = this._lastCompilerResult[fileName];
            if (oldHash != null && oldHash == newHash) {
                return false;
            }

            this._lastCompilerResult[fileName] = newHash;
            return true;
        }

        return false;
    }

    reset() {
        this._lastCompilerResult = {};
    }
}

function calcHash(content:string):HashType {
    return crypto.createHash('md5').update(content).digest("hex");
}