/// <reference path="protocol.d.ts" />
/// <reference path="session.d.ts" />
declare namespace ts.server {
    interface Logger {
        close(): void;
        isVerbose(): boolean;
        loggingEnabled(): boolean;
        perftrc(s: string): void;
        info(s: string): void;
        startGroup(): void;
        endGroup(): void;
        msg(s: string, type?: string): void;
    }
    class ScriptInfo {
        private host;
        fileName: string;
        content: string;
        isOpen: boolean;
        svc: ScriptVersionCache;
        children: ScriptInfo[];
        defaultProject: Project;
        fileWatcher: FileWatcher;
        formatCodeOptions: FormatCodeOptions;
        path: Path;
        constructor(host: ServerHost, fileName: string, content: string, isOpen?: boolean);
        setFormatOptions(formatOptions: protocol.FormatOptions): void;
        close(): void;
        addChild(childInfo: ScriptInfo): void;
        snap(): LineIndexSnapshot;
        getText(): string;
        getLineInfo(line: number): ILineInfo;
        editContent(start: number, end: number, newText: string): void;
        getTextChangeRangeBetweenVersions(startVersion: number, endVersion: number): ts.TextChangeRange;
        getChangeRange(oldSnapshot: ts.IScriptSnapshot): ts.TextChangeRange;
    }
    class LSHost implements ts.LanguageServiceHost {
        host: ServerHost;
        project: Project;
        ls: ts.LanguageService;
        compilationSettings: ts.CompilerOptions;
        filenameToScript: ts.FileMap<ScriptInfo>;
        roots: ScriptInfo[];
        private resolvedModuleNames;
        private moduleResolutionHost;
        private getCanonicalFileName;
        constructor(host: ServerHost, project: Project);
        resolveModuleNames(moduleNames: string[], containingFile: string): ResolvedModule[];
        getDefaultLibFileName(): string;
        getScriptSnapshot(filename: string): ts.IScriptSnapshot;
        setCompilationSettings(opt: ts.CompilerOptions): void;
        lineAffectsRefs(filename: string, line: number): boolean;
        getCompilationSettings(): CompilerOptions;
        getScriptFileNames(): string[];
        getScriptKind(): ScriptKind;
        getScriptVersion(filename: string): string;
        getCurrentDirectory(): string;
        getScriptIsOpen(filename: string): boolean;
        removeReferencedFile(info: ScriptInfo): void;
        getScriptInfo(filename: string): ScriptInfo;
        addRoot(info: ScriptInfo): void;
        removeRoot(info: ScriptInfo): void;
        saveTo(filename: string, tmpfilename: string): void;
        reloadScript(filename: string, tmpfilename: string, cb: () => any): void;
        editScript(filename: string, start: number, end: number, newText: string): void;
        resolvePath(path: string): string;
        fileExists(path: string): boolean;
        directoryExists(path: string): boolean;
        lineToTextSpan(filename: string, line: number): ts.TextSpan;
        lineOffsetToPosition(filename: string, line: number, offset: number): number;
        positionToLineOffset(filename: string, position: number): ILineInfo;
    }
    interface ProjectOptions {
        files?: string[];
        compilerOptions?: ts.CompilerOptions;
    }
    class Project {
        projectService: ProjectService;
        projectOptions: ProjectOptions;
        compilerService: CompilerService;
        projectFilename: string;
        projectFileWatcher: FileWatcher;
        directoryWatcher: FileWatcher;
        directoriesWatchedForTsconfig: string[];
        program: ts.Program;
        filenameToSourceFile: ts.Map<ts.SourceFile>;
        updateGraphSeq: number;
        openRefCount: number;
        constructor(projectService: ProjectService, projectOptions?: ProjectOptions);
        addOpenRef(): void;
        deleteOpenRef(): number;
        openReferencedFile(filename: string): ScriptInfo;
        getRootFiles(): string[];
        getFileNames(): string[];
        getSourceFile(info: ScriptInfo): SourceFile;
        getSourceFileFromName(filename: string, requireOpen?: boolean): SourceFile;
        isRoot(info: ScriptInfo): boolean;
        removeReferencedFile(info: ScriptInfo): void;
        updateFileMap(): void;
        finishGraph(): void;
        updateGraph(): void;
        isConfiguredProject(): string;
        addRoot(info: ScriptInfo): void;
        removeRoot(info: ScriptInfo): void;
        filesToString(): string;
        setProjectOptions(projectOptions: ProjectOptions): void;
    }
    interface ProjectOpenResult {
        success?: boolean;
        errorMsg?: string;
        project?: Project;
    }
    interface ProjectServiceEventHandler {
        (eventName: string, project: Project, fileName: string): void;
    }
    interface HostConfiguration {
        formatCodeOptions: ts.FormatCodeOptions;
        hostInfo: string;
    }
    class ProjectService {
        host: ServerHost;
        psLogger: Logger;
        eventHandler: ProjectServiceEventHandler;
        filenameToScriptInfo: ts.Map<ScriptInfo>;
        openFileRoots: ScriptInfo[];
        inferredProjects: Project[];
        configuredProjects: Project[];
        openFilesReferenced: ScriptInfo[];
        openFileRootsConfigured: ScriptInfo[];
        directoryWatchersForTsconfig: ts.Map<FileWatcher>;
        directoryWatchersRefCount: ts.Map<number>;
        hostConfiguration: HostConfiguration;
        timerForDetectingProjectFileListChanges: Map<NodeJS.Timer>;
        constructor(host: ServerHost, psLogger: Logger, eventHandler?: ProjectServiceEventHandler);
        addDefaultHostConfiguration(): void;
        getFormatCodeOptions(file?: string): FormatCodeOptions;
        watchedFileChanged(fileName: string): void;
        directoryWatchedForSourceFilesChanged(project: Project, fileName: string): void;
        startTimerForDetectingProjectFileListChanges(project: Project): void;
        handleProjectFileListChanges(project: Project): void;
        directoryWatchedForTsconfigChanged(fileName: string): void;
        getCanonicalFileName(fileName: string): string;
        watchedProjectConfigFileChanged(project: Project): void;
        log(msg: string, type?: string): void;
        setHostConfiguration(args: ts.server.protocol.ConfigureRequestArguments): void;
        closeLog(): void;
        createInferredProject(root: ScriptInfo): Project;
        fileDeletedInFilesystem(info: ScriptInfo): void;
        updateConfiguredProjectList(): void;
        removeProject(project: Project): void;
        setConfiguredProjectRoot(info: ScriptInfo): boolean;
        addOpenFile(info: ScriptInfo): void;
        closeOpenFile(info: ScriptInfo): void;
        findReferencingProjects(info: ScriptInfo, excludedProject?: Project): Project[];
        reloadProjects(): void;
        updateProjectStructure(): void;
        getScriptInfo(filename: string): ScriptInfo;
        openFile(fileName: string, openedByClient: boolean, fileContent?: string): ScriptInfo;
        findConfigFile(searchPath: string): string;
        openClientFile(fileName: string, fileContent?: string): ScriptInfo;
        openOrUpdateConfiguredProjectForFile(fileName: string): void;
        closeClientFile(filename: string): void;
        getProjectForFile(filename: string): Project;
        printProjectsForFile(filename: string): void;
        printProjects(): void;
        configProjectIsActive(fileName: string): boolean;
        findConfiguredProjectByConfigFile(configFileName: string): Project;
        configFileToProjectOptions(configFilename: string): {
            succeeded: boolean;
            projectOptions?: ProjectOptions;
            error?: ProjectOpenResult;
        };
        openConfigFile(configFilename: string, clientFileName?: string): ProjectOpenResult;
        updateConfiguredProject(project: Project): ProjectOpenResult;
        createProject(projectFilename: string, projectOptions?: ProjectOptions): Project;
    }
    class CompilerService {
        project: Project;
        host: LSHost;
        languageService: ts.LanguageService;
        classifier: ts.Classifier;
        settings: ts.CompilerOptions;
        documentRegistry: DocumentRegistry;
        constructor(project: Project, opt?: ts.CompilerOptions);
        setCompilerOptions(opt: ts.CompilerOptions): void;
        isExternalModule(filename: string): boolean;
        static defaultFormatCodeOptions: ts.FormatCodeOptions;
    }
    interface LineCollection {
        charCount(): number;
        lineCount(): number;
        isLeaf(): boolean;
        walk(rangeStart: number, rangeLength: number, walkFns: ILineIndexWalker): void;
    }
    interface ILineInfo {
        line: number;
        offset: number;
        text?: string;
        leaf?: LineLeaf;
    }
    enum CharRangeSection {
        PreStart = 0,
        Start = 1,
        Entire = 2,
        Mid = 3,
        End = 4,
        PostEnd = 5,
    }
    interface ILineIndexWalker {
        goSubtree: boolean;
        done: boolean;
        leaf(relativeStart: number, relativeLength: number, lineCollection: LineLeaf): void;
        pre?(relativeStart: number, relativeLength: number, lineCollection: LineCollection, parent: LineNode, nodeType: CharRangeSection): LineCollection;
        post?(relativeStart: number, relativeLength: number, lineCollection: LineCollection, parent: LineNode, nodeType: CharRangeSection): LineCollection;
    }
    class TextChange {
        pos: number;
        deleteLen: number;
        insertedText: string;
        constructor(pos: number, deleteLen: number, insertedText?: string);
        getTextChangeRange(): TextChangeRange;
    }
    class ScriptVersionCache {
        changes: TextChange[];
        versions: LineIndexSnapshot[];
        minVersion: number;
        private currentVersion;
        private host;
        static changeNumberThreshold: number;
        static changeLengthThreshold: number;
        static maxVersions: number;
        edit(pos: number, deleteLen: number, insertedText?: string): void;
        latest(): LineIndexSnapshot;
        latestVersion(): number;
        reloadFromFile(filename: string, cb?: () => any): void;
        reload(script: string): void;
        getSnapshot(): LineIndexSnapshot;
        getTextChangesBetweenVersions(oldVersion: number, newVersion: number): TextChangeRange;
        static fromString(host: ServerHost, script: string): ScriptVersionCache;
    }
    class LineIndexSnapshot implements ts.IScriptSnapshot {
        version: number;
        cache: ScriptVersionCache;
        index: LineIndex;
        changesSincePreviousVersion: TextChange[];
        constructor(version: number, cache: ScriptVersionCache);
        getText(rangeStart: number, rangeEnd: number): string;
        getLength(): number;
        getLineStartPositions(): number[];
        getLineMapper(): (line: number) => number;
        getTextChangeRangeSinceVersion(scriptVersion: number): TextChangeRange;
        getChangeRange(oldSnapshot: ts.IScriptSnapshot): ts.TextChangeRange;
    }
    class LineIndex {
        root: LineNode;
        checkEdits: boolean;
        charOffsetToLineNumberAndPos(charOffset: number): ILineInfo;
        lineNumberToInfo(lineNumber: number): ILineInfo;
        load(lines: string[]): void;
        walk(rangeStart: number, rangeLength: number, walkFns: ILineIndexWalker): void;
        getText(rangeStart: number, rangeLength: number): string;
        getLength(): number;
        every(f: (ll: LineLeaf, s: number, len: number) => boolean, rangeStart: number, rangeEnd?: number): boolean;
        edit(pos: number, deleteLength: number, newText?: string): LineIndex;
        static buildTreeFromBottom(nodes: LineCollection[]): LineNode;
        static linesFromText(text: string): {
            lines: string[];
            lineMap: number[];
        };
    }
    class LineNode implements LineCollection {
        totalChars: number;
        totalLines: number;
        children: LineCollection[];
        isLeaf(): boolean;
        updateCounts(): void;
        execWalk(rangeStart: number, rangeLength: number, walkFns: ILineIndexWalker, childIndex: number, nodeType: CharRangeSection): boolean;
        skipChild(relativeStart: number, relativeLength: number, childIndex: number, walkFns: ILineIndexWalker, nodeType: CharRangeSection): void;
        walk(rangeStart: number, rangeLength: number, walkFns: ILineIndexWalker): void;
        charOffsetToLineNumberAndPos(lineNumber: number, charOffset: number): ILineInfo;
        lineNumberToInfo(lineNumber: number, charOffset: number): ILineInfo;
        childFromLineNumber(lineNumber: number, charOffset: number): {
            child: LineCollection;
            childIndex: number;
            relativeLineNumber: number;
            charOffset: number;
        };
        childFromCharOffset(lineNumber: number, charOffset: number): {
            child: LineCollection;
            childIndex: number;
            charOffset: number;
            lineNumber: number;
        };
        splitAfter(childIndex: number): LineNode;
        remove(child: LineCollection): void;
        findChildIndex(child: LineCollection): number;
        insertAt(child: LineCollection, nodes: LineCollection[]): LineNode[];
        add(collection: LineCollection): boolean;
        charCount(): number;
        lineCount(): number;
    }
    class LineLeaf implements LineCollection {
        text: string;
        udata: any;
        constructor(text: string);
        setUdata(data: any): void;
        getUdata(): any;
        isLeaf(): boolean;
        walk(rangeStart: number, rangeLength: number, walkFns: ILineIndexWalker): void;
        charCount(): number;
        lineCount(): number;
    }
}
