/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemKey;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

@Presentation(typeName = "@Service")
public class SpringService extends SpringMetaStereotypeComponent {

  public static final SemKey<JamMemberMeta<PsiClass, SpringService>> META_KEY =
    JamService.ALIASING_MEMBER_META_KEY.subKey("SpringServiceMeta");

  public static final SemKey<SpringService> JAM_KEY =
    JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY.subKey("SpringService");

  public static final JamClassMeta<SpringService> META =
    new JamClassMeta<SpringService>(null, SpringService.class, JAM_KEY);

  private static final Function<Module, Collection<String>> ANNOTATIONS =
    module -> getAnnotations(module, SpringAnnotationsConstants.SERVICE);

  public SpringService(@NotNull PsiClass psiClass) {
    this(SpringAnnotationsConstants.SERVICE, psiClass);
  }

  public SpringService(@NotNull String anno, @NotNull PsiClass psiClass) {
    super(anno, psiClass);
  }

  @NotNull
  public static Function<Pair<String, PsiClass>, SpringService> getServiceProducer() {
    return pair -> new SpringService(pair.first, pair.second);
  }

  @NotNull
  public static Function<Module, Collection<String>> getServiceAnnotations() {
    return ANNOTATIONS;
  }
}
