/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml.beans;

import com.intellij.psi.PsiType;
import com.intellij.spring.constants.SpringConstants;
import com.intellij.spring.model.converters.ConstructorArgIndexConverter;
import com.intellij.spring.model.converters.ConstructorArgNameConverter;
import com.intellij.util.xml.*;
import org.jetbrains.annotations.NotNull;

@Namespace(SpringConstants.BEANS_NAMESPACE_KEY)
public interface ConstructorArg extends ConstructorArgDefinition, SpringInjection {

  @Stubbed
  @NotNull
  @Attribute(value = "name")
  @Convert(ConstructorArgNameConverter.class)
  @NameValue(unique = true)
  GenericAttributeValue<String> getNameAttr();

  boolean isAssignable(@NotNull PsiType to);

  /**
   * Returns the value of the index child.
   * <pre>
   * <h3>Attribute null:index documentation</h3>
   * 	The exact index of thr argument in the constructor argument list.
   * 	Only needed to avoid ambiguities, e.g. in case of 2 arguments of
   * 	the exact same type.
   *
   * </pre>
   * @return the value of the index child.
   */
  @Stubbed
  @Referencing(ConstructorArgIndexConverter.class)
  @NotNull
  GenericAttributeValue<Integer> getIndex();

  /**
   * Returns the value of the type child.
   * <pre>
   * <h3>Attribute null:type documentation</h3>
   * 	The exact type of the constructor argument. Only needed to avoid
   * 	ambiguities, e.g. in case of 2 single argument constructors
   * 	that can both be converted from a String.
   *
   * </pre>
   * @return the value of the type child.
   */
  @Stubbed
  @NotNull
  GenericAttributeValue<PsiType> getType();
}
