/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.List;

public class DataSourceTemplateAdapter implements DataSourceTemplate {
  protected final DataSourceTemplate myDelegate;

  public DataSourceTemplateAdapter(@NotNull DataSourceTemplate delegate) {
    myDelegate = delegate;
  }

  @NotNull
  @Override
  public String getName() {
    return myDelegate.getName();
  }

  @NotNull
  @Override
  public String getFullName() {
    return myDelegate.getFullName();
  }

  @NotNull
  @Override
  public List<DataSourceTemplate> getSubConfigurations() {
    return myDelegate.getSubConfigurations();
  }

  @NotNull
  @Override
  public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
    return myDelegate.createDataSource(project, copyFrom, newName);
  }

  @Override
  public Icon getIcon(@IconFlags int flags) {
    return myDelegate.getIcon(flags);
  }
}
