package com.intellij.database.model;

import com.intellij.database.util.DasUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author gregsh
 */
public interface DasObject {

  @NotNull
  ObjectKind getKind();

  /**
   * Returns name or DasUtil.NO_NAME
   */
  @NotNull
  String getName();

  @Nullable
  String getComment();

  @Nullable
  DasObject getDbParent();

  @NotNull
  <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind);

  //@Nullable
  //<C> Iterable<C> findDbChildren(String name, Class<C> clazz, ObjectKind... type);

  abstract class Adapter implements DasObject {

    @NotNull
    @Override
    public String getName() {
      return DasUtil.NO_NAME;
    }

    @Nullable
    @Override
    public String getComment() {
      return null;
    }

    @Override
    public DasObject getDbParent() {
      return null;
    }

    @NotNull
    @Override
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
      return JBIterable.empty();
    }
  }
}
