package com.intellij.psi.css;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.awt.*;
import java.util.Collection;

public abstract class ForwardingCssElementDescriptorProvider extends CssElementDescriptorProvider {
  protected final CssElementDescriptorProvider myBaseDescriptorProvider;

  public ForwardingCssElementDescriptorProvider(CssElementDescriptorProvider baseDescriptorProvider) {
    myBaseDescriptorProvider = baseDescriptorProvider;
  }

  @Override
  public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
    return myBaseDescriptorProvider.isPossibleSelector(selector, context);
  }

  @NotNull
  @Override
  public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name) {
    return myBaseDescriptorProvider.findPseudoSelectorDescriptors(name);
  }

  @NotNull
  @Override
  public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
    return myBaseDescriptorProvider.getNamedValueDescriptors(name, parent);
  }

  @NotNull
  @Override
  public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
    return myBaseDescriptorProvider.findPropertyDescriptors(propertyName, context);
  }

  @NotNull
  @Override
  public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
    return myBaseDescriptorProvider.findFunctionDescriptors(functionName, context);
  }
  
  @NotNull
  @Override
  public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String mediaFeatureName, @Nullable PsiElement context) {
    return myBaseDescriptorProvider.findMediaFeatureDescriptors(mediaFeatureName, context);
  }

  @Override
  public boolean isPossiblePseudoSelector(@NotNull String selectorName, @Nullable PsiElement context) {
    return myBaseDescriptorProvider.isPossiblePseudoSelector(selectorName, context);
  }

  @NotNull
  @Override
  public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
    return myBaseDescriptorProvider.getAllPseudoSelectorDescriptors(context);
  }

  @NotNull
  @Override
  public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
    return myBaseDescriptorProvider.getAllPropertyDescriptors(context);
  }

  @NotNull
  @Override
  public Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
    return myBaseDescriptorProvider.getAllMediaFeatureDescriptors(context);
  }

  @NotNull
  @Override
  public String[] getSimpleSelectors(@NotNull PsiElement context) {
    return myBaseDescriptorProvider.getSimpleSelectors(context);
  }

  @NotNull
  @Override
  public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
    return myBaseDescriptorProvider.getDeclarationsForSimpleSelector(selector);
  }

  @Nullable
  @Override
  public PsiElement getDocumentationElementForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
    return myBaseDescriptorProvider.getDocumentationElementForSelector(selectorName, context);
  }

  @Override
  public boolean providesClassicCss() {
    return myBaseDescriptorProvider.providesClassicCss();
  }

  @Nullable
  @Override
  public String generateDocForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
    return myBaseDescriptorProvider.generateDocForSelector(selectorName, context);
  }

  @NotNull
  @Override
  public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
    return myBaseDescriptorProvider.getStyleReference(element, start, end, caseSensitive);
  }

  @NotNull
  @Override
  public CssValueValidator getValueValidator() {
    return myBaseDescriptorProvider.getValueValidator();
  }

  @Nullable
  @Override
  public Color getColorByValue(@NotNull String value) {
    return myBaseDescriptorProvider.getColorByValue(value);
  }

  @NotNull
  @Override
  public LocalQuickFix[] getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
    return myBaseDescriptorProvider.getQuickFixesForUnknownProperty(propertyName, context, isOnTheFly);
  }

  @NotNull
  @Override
  public LocalQuickFix[] getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName,
                                                               @NotNull PsiElement context,
                                                               boolean isOnTheFly) {
    return myBaseDescriptorProvider.getQuickFixesForUnknownSimpleSelector(selectorName, context, isOnTheFly);
  }

  @Override
  public boolean isColorTermsSupported() {
    return myBaseDescriptorProvider.isColorTermsSupported();
  }

  @Override
  public CssContextType getCssContextType(@Nullable PsiElement context) {
    return myBaseDescriptorProvider.getCssContextType(context);
  }

  @Override
  public boolean isColorTerm(@NotNull CssTerm term) {
    return myBaseDescriptorProvider.isColorTerm(term);
  }
}
