package com.intellij.psi.css.descriptor;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.*;
import com.intellij.psi.css.descriptor.value.CssNullValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

public class CssPropertyDescriptorStub implements CssPropertyDescriptor {
  @NonNls private static final String EMPTY_STRING = "";
  private final String myName;

  public CssPropertyDescriptorStub(String name) {
    myName = name;
  }

  @NotNull
  @Override
  public String getId() {
    return myName;
  }

  @NotNull
  @Override
  public String getPresentableName() {
    return getId();
  }

  @NotNull
  @Override
  public CssVersion getCssVersion() {
    return CssVersion.UNKNOWN;
  }

  @NotNull
  @Override
  public BrowserVersion[] getBrowsers() {
    return new BrowserVersion[0];
  }

  @NotNull
  @Override
  public CssValueDescriptor getValueDescriptor() {
    //todo reimplement with real values
    return new CssNullValue();
  }

  @Override
  public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
    return true;
  }

  @NotNull
  @Override
  public String getDescription() {
    return EMPTY_STRING;
  }

  @Nullable
  @Override
  public String getDocumentationString(@Nullable PsiElement context) {
    return null;
  }

  @NotNull
  @Override
  public String getElementTypeName() {
    return CssBundle.message("css.function");
  }

  @Nullable
  @Override
  public String getSpecificationUrl() {
    return null;
  }

  @NotNull
  @Override
  public CssContextType[] getAllowedContextTypes() {
    return CssContextType.EMPTY_ARRAY;
  }
  
  @Nullable
  @Override
  public Icon getIcon() {
    return AllIcons.Css.Property;
  }

  
  // todo: delete all below
  
  @NotNull
  @Override
  public CssMediaGroup[] getMediaGroups() {
    return new CssMediaGroup[0];
  }

  @Override
  public boolean isValidValue(@NotNull PsiElement element) {
    return false;
  }

  @Override
  public boolean isShorthandValue() {
    return false;
  }

  @NotNull
  @Override
  public String[] expand(@NotNull CssDeclaration declaration) {
    return ArrayUtil.EMPTY_STRING_ARRAY;
  }

  @Nullable
  @Override
  public PsiElement[] getShorthandPsiValue(@NotNull CssDeclaration decl, @NotNull String propertyName) {
    return new PsiElement[0];
  }

  @Override
  public boolean is4ValueProperty() {
    return false;
  }

  @Override
  public CssPropertyValue getReferencedPropertyValue(@NotNull String name) {
    return null;
  }

  @NotNull
  @Override
  public CssPropertyInfo[] getInfos() {
    return new CssPropertyInfo[0];
  }

  @Override
  public boolean isInherited() {
    return false;
  }

  @Nullable
  @Override
  public String getInitialValue() {
    return null;
  }

  @Nullable
  @Override
  public String getAppliesToValue() {
    return null;
  }

  @Nullable
  @Override
  public String getPercentageValue() {
    return null;
  }

  @NotNull
  @Override
  public String getPropertyName() {
    return getId();
  }

  @Override
  public Object[] getAllVariants() {
    return ArrayUtil.EMPTY_OBJECT_ARRAY;
  }

  @Nullable
  @Override
  public String[] getRefNames() {
    return ArrayUtil.EMPTY_STRING_ARRAY;
  }

  @NotNull
  @Override
  public Object[] getVariants(@NotNull PsiElement contextElement) {
    return ArrayUtil.EMPTY_OBJECT_ARRAY;
  }

  @Override
  public boolean getInherited() {
    return false;
  }

  @NotNull
  @Override
  public String toCanonicalName(@NotNull String propertyName) {
    return propertyName;
  }

  @Override
  public CssPropertyValue getValue() {
    return null;
  }

  @NotNull
  @Override
  public PsiElement[] getDeclarations(PsiElement context) {
    return new PsiElement[0];
  }

  @Override
  public boolean allowsIntegerWithoutSuffix() {
    return false;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof CssPropertyDescriptorStub)) return false;

    CssPropertyDescriptorStub stub = (CssPropertyDescriptorStub)o;

    if (myName != null ? !myName.equals(stub.myName) : stub.myName != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    return myName != null ? myName.hashCode() : 0;
  }
}
